/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.websocket;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.listener.websocket.WebsocketConfigurator;
import org.apache.shenyu.admin.service.SyncDataService;
import org.apache.shenyu.admin.spring.SpringBeanUtils;
import org.apache.shenyu.admin.utils.ThreadLocalUtil;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/websocket", configurator=WebsocketConfigurator.class)
public class WebsocketCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebsocketCollector.class);
    private static final Set<Session> SESSION_SET = new CopyOnWriteArraySet<Session>();
    private static final String SESSION_KEY = "sessionKey";

    @OnOpen
    public void onOpen(Session session) {
        log.info("websocket on client[{}] open successful....", (Object)WebsocketCollector.getClientIp(session));
        SESSION_SET.add(session);
    }

    private static String getClientIp(Session session) {
        Map userProperties = session.getUserProperties();
        if (MapUtils.isEmpty((Map)userProperties)) {
            return "";
        }
        Object ipObject = userProperties.get("ClientIP");
        if (null == ipObject) {
            return "";
        }
        return ipObject.toString();
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        if (message.equals(DataEventTypeEnum.MYSELF.name())) {
            try {
                ThreadLocalUtil.put(SESSION_KEY, session);
                SpringBeanUtils.getInstance().getBean(SyncDataService.class).syncAll(DataEventTypeEnum.MYSELF);
            }
            finally {
                ThreadLocalUtil.clear();
            }
        }
    }

    @OnClose
    public void onClose(Session session) {
        SESSION_SET.remove(session);
        ThreadLocalUtil.clear();
        log.warn("websocket close on client[{}]", (Object)WebsocketCollector.getClientIp(session));
    }

    @OnError
    public void onError(Session session, Throwable error) {
        SESSION_SET.remove(session);
        ThreadLocalUtil.clear();
        log.error("websocket collection on client[{}] error: ", (Object)WebsocketCollector.getClientIp(session), (Object)error);
    }

    public static void send(String message, DataEventTypeEnum type) {
        if (StringUtils.isNotBlank((CharSequence)message)) {
            if (DataEventTypeEnum.MYSELF == type) {
                Session session2 = (Session)ThreadLocalUtil.get(SESSION_KEY);
                if (session2 != null) {
                    WebsocketCollector.sendMessageBySession(session2, message);
                }
            } else {
                SESSION_SET.forEach(session -> WebsocketCollector.sendMessageBySession(session, message));
            }
        }
    }

    private static void sendMessageBySession(Session session, String message) {
        try {
            session.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            log.error("websocket send result is exception: ", (Throwable)e);
        }
    }
}

