/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.zookeeper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.I0Itec.zkclient.ZkClient;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.DivideUpstream;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Deprecated
public class HttpServiceDiscovery
implements InitializingBean {
    private static final String ROOT = "/shenyu/register";
    private ZkClient zkClient;
    private final SelectorService selectorService;
    private final SelectorMapper selectorMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final Environment env;
    private volatile List<String> contextPathList;

    @Autowired(required=false)
    public HttpServiceDiscovery(SelectorService selectorService, SelectorMapper selectorMapper, ApplicationEventPublisher eventPublisher, Environment env) {
        this.selectorService = selectorService;
        this.selectorMapper = selectorMapper;
        this.eventPublisher = eventPublisher;
        this.env = env;
    }

    public void afterPropertiesSet() {
        Boolean register = (Boolean)this.env.getProperty("shenyu.http.register", Boolean.class, (Object)false);
        if (!register.booleanValue()) {
            return;
        }
        String zookeeperUrl = this.env.getProperty("shenyu.http.zookeeperUrl", "");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{zookeeperUrl})) {
            this.zkClient = new ZkClient(zookeeperUrl, 5000, 2000);
            boolean exists = this.zkClient.exists(ROOT);
            if (!exists) {
                this.zkClient.createPersistent(ROOT, true);
            }
            this.contextPathList = this.zkClient.getChildren(ROOT);
            this.updateServerNode(this.contextPathList);
            this.zkClient.subscribeChildChanges(ROOT, (parentPath, childs) -> {
                List<String> addSubscribePath = this.addSubscribePath(this.contextPathList, childs);
                this.updateServerNode(addSubscribePath);
                this.contextPathList = childs;
            });
        }
    }

    private void updateServerNode(List<String> serverNodeList) {
        for (String children : serverNodeList) {
            String serverPath = this.buildServerPath(children);
            List realPath = this.zkClient.getChildren(serverPath);
            List<String> collect = realPath.stream().map(r -> this.buildRealPath(children, (String)r)).collect(Collectors.toList());
            this.updateServiceList(collect, "/" + children);
            this.subscribeChildChanges(serverPath);
        }
    }

    private void subscribeChildChanges(String children) {
        this.zkClient.subscribeChildChanges(children, (parentPath, currentChilds) -> {
            String[] split = StringUtils.split((String)parentPath, (String)"/");
            String contextPath = "/" + split[2];
            if (CollectionUtils.isEmpty((Collection)currentChilds)) {
                this.updateSelectorHandler(contextPath, null);
            } else {
                ArrayList<String> uriList = new ArrayList<String>();
                for (String subNode : currentChilds) {
                    String data = (String)this.zkClient.readData(parentPath + "/" + subNode);
                    uriList.add(data);
                }
                this.updateSelectorHandler(contextPath, uriList);
            }
        });
    }

    private List<String> addSubscribePath(List<String> alreadyChildren, List<String> currentChildren) {
        if (CollectionUtils.isEmpty(alreadyChildren)) {
            return currentChildren;
        }
        return currentChildren.stream().filter(current -> alreadyChildren.stream().noneMatch(current::equals)).collect(Collectors.toList());
    }

    private void updateServiceList(List<String> children, String contextPath) {
        ArrayList<String> uriList = new ArrayList<String>();
        for (String subNode : children) {
            String data = (String)this.zkClient.readData(subNode);
            uriList.add(data);
        }
        this.updateSelectorHandler(contextPath, uriList);
    }

    private void updateSelectorHandler(String contextPath, List<String> uriList) {
        SelectorDO selector = this.selectorService.findByName(contextPath);
        if (Objects.nonNull(selector)) {
            SelectorData selectorData = this.selectorService.buildByName(contextPath);
            if (uriList == null) {
                selector.setHandle("");
                selectorData.setHandle("");
            } else {
                String handler = GsonUtils.getInstance().toJson(this.buildDivideUpstream(uriList));
                selector.setHandle(handler);
                selectorData.setHandle(handler);
            }
            this.selectorMapper.updateSelective(selector);
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.UPDATE, Collections.singletonList(selectorData)));
        }
    }

    private List<DivideUpstream> buildDivideUpstream(List<String> uriList) {
        return uriList.stream().map(uri -> {
            DivideUpstream divideUpstream = DivideUpstream.builder().upstreamHost("localhost").protocol("http://").upstreamUrl(uri).weight(50).build();
            return divideUpstream;
        }).collect(Collectors.toList());
    }

    private String buildServerPath(String serverNode) {
        return "/shenyu/register/" + serverNode;
    }

    private String buildRealPath(String serverNode, String path) {
        return "/shenyu/register/" + serverNode + "/" + path;
    }
}

