/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.AppAuthDTO;
import org.apache.shenyu.admin.model.dto.AuthApplyDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.SignUtils;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class AppAuthDO
extends BaseDO {
    private static final long serialVersionUID = 5683408559456006830L;
    private String appKey;
    private String appSecret;
    private Boolean enabled;
    private Boolean open;
    private String userId;
    private String phone;
    private String extInfo;

    public static AppAuthDO create(AppAuthDTO appAuthDTO) {
        return Optional.ofNullable(appAuthDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            BaseDO appAuthDO = ((AppAuthDOBuilder)((BaseDO.BaseDOBuilder)((AppAuthDOBuilder)((AppAuthDOBuilder)((AppAuthDOBuilder)AppAuthDO.builder().appKey(item.getAppKey())).appSecret(item.getAppSecret())).open(item.getOpen())).enabled(item.getEnabled())).dateUpdated(currentTime)).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                appAuthDO.setId(UUIDUtils.getInstance().generateShortUuid());
                appAuthDO.setDateCreated(currentTime);
            } else {
                appAuthDO.setId(item.getId());
            }
            return appAuthDO;
        }).orElse(null);
    }

    public static AppAuthDO create(AuthApplyDTO authApplyDTO) {
        return Optional.ofNullable(authApplyDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            return ((AppAuthDOBuilder)((AppAuthDOBuilder)((BaseDO.BaseDOBuilder)((AppAuthDOBuilder)((AppAuthDOBuilder)((AppAuthDOBuilder)((AppAuthDOBuilder)((AppAuthDOBuilder)((AppAuthDOBuilder)((AppAuthDOBuilder)AppAuthDO.builder().id(UUIDUtils.getInstance().generateShortUuid())).userId(item.getUserId())).phone(item.getPhone())).extInfo(item.getExtInfo())).appKey(SignUtils.getInstance().generateKey())).appSecret(SignUtils.getInstance().generateKey())).open(item.getOpen())).enabled(true)).dateCreated(currentTime)).dateUpdated(currentTime)).build();
        }).orElse(null);
    }

    @Generated
    protected AppAuthDO(AppAuthDOBuilder<?, ?> b) {
        super(b);
        this.appKey = ((AppAuthDOBuilder)b).appKey;
        this.appSecret = ((AppAuthDOBuilder)b).appSecret;
        this.enabled = ((AppAuthDOBuilder)b).enabled;
        this.open = ((AppAuthDOBuilder)b).open;
        this.userId = ((AppAuthDOBuilder)b).userId;
        this.phone = ((AppAuthDOBuilder)b).phone;
        this.extInfo = ((AppAuthDOBuilder)b).extInfo;
    }

    @Generated
    public static AppAuthDOBuilder<?, ?> builder() {
        return new AppAuthDOBuilderImpl();
    }

    @Generated
    public String getAppKey() {
        return this.appKey;
    }

    @Generated
    public String getAppSecret() {
        return this.appSecret;
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public Boolean getOpen() {
        return this.open;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public String getPhone() {
        return this.phone;
    }

    @Generated
    public String getExtInfo() {
        return this.extInfo;
    }

    @Generated
    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    @Generated
    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setOpen(Boolean open) {
        this.open = open;
    }

    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Generated
    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Generated
    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    @Override
    @Generated
    public String toString() {
        return "AppAuthDO(appKey=" + this.getAppKey() + ", appSecret=" + this.getAppSecret() + ", enabled=" + this.getEnabled() + ", open=" + this.getOpen() + ", userId=" + this.getUserId() + ", phone=" + this.getPhone() + ", extInfo=" + this.getExtInfo() + ")";
    }

    @Generated
    public AppAuthDO() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppAuthDO)) {
            return false;
        }
        AppAuthDO other = (AppAuthDO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$appKey = this.getAppKey();
        String other$appKey = other.getAppKey();
        if (this$appKey == null ? other$appKey != null : !this$appKey.equals(other$appKey)) {
            return false;
        }
        String this$appSecret = this.getAppSecret();
        String other$appSecret = other.getAppSecret();
        if (this$appSecret == null ? other$appSecret != null : !this$appSecret.equals(other$appSecret)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$open = this.getOpen();
        Boolean other$open = other.getOpen();
        if (this$open == null ? other$open != null : !((Object)this$open).equals(other$open)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        String this$extInfo = this.getExtInfo();
        String other$extInfo = other.getExtInfo();
        return !(this$extInfo == null ? other$extInfo != null : !this$extInfo.equals(other$extInfo));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AppAuthDO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $appKey = this.getAppKey();
        result = result * 59 + ($appKey == null ? 43 : $appKey.hashCode());
        String $appSecret = this.getAppSecret();
        result = result * 59 + ($appSecret == null ? 43 : $appSecret.hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $open = this.getOpen();
        result = result * 59 + ($open == null ? 43 : ((Object)$open).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        String $extInfo = this.getExtInfo();
        result = result * 59 + ($extInfo == null ? 43 : $extInfo.hashCode());
        return result;
    }

    @Generated
    private static final class AppAuthDOBuilderImpl
    extends AppAuthDOBuilder<AppAuthDO, AppAuthDOBuilderImpl> {
        @Generated
        private AppAuthDOBuilderImpl() {
        }

        @Override
        @Generated
        protected AppAuthDOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AppAuthDO build() {
            return new AppAuthDO(this);
        }
    }

    @Generated
    public static abstract class AppAuthDOBuilder<C extends AppAuthDO, B extends AppAuthDOBuilder<C, B>>
    extends BaseDO.BaseDOBuilder<C, B> {
        @Generated
        private String appKey;
        @Generated
        private String appSecret;
        @Generated
        private Boolean enabled;
        @Generated
        private Boolean open;
        @Generated
        private String userId;
        @Generated
        private String phone;
        @Generated
        private String extInfo;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B appKey(String appKey) {
            this.appKey = appKey;
            return (B)this.self();
        }

        @Generated
        public B appSecret(String appSecret) {
            this.appSecret = appSecret;
            return (B)this.self();
        }

        @Generated
        public B enabled(Boolean enabled) {
            this.enabled = enabled;
            return (B)this.self();
        }

        @Generated
        public B open(Boolean open) {
            this.open = open;
            return (B)this.self();
        }

        @Generated
        public B userId(String userId) {
            this.userId = userId;
            return (B)this.self();
        }

        @Generated
        public B phone(String phone) {
            this.phone = phone;
            return (B)this.self();
        }

        @Generated
        public B extInfo(String extInfo) {
            this.extInfo = extInfo;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "AppAuthDO.AppAuthDOBuilder(super=" + super.toString() + ", appKey=" + this.appKey + ", appSecret=" + this.appSecret + ", enabled=" + this.enabled + ", open=" + this.open + ", userId=" + this.userId + ", phone=" + this.phone + ", extInfo=" + this.extInfo + ")";
        }
    }
}

