/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.page;

import java.io.Serializable;
import lombok.Generated;

public class PageParameter
implements Serializable {
    private static final long serialVersionUID = -8324693985921606090L;
    private static final int DEFAULT_PAGE_SIZE = 12;
    private int currentPage;
    private int prePage;
    private int nextPage;
    private int pageSize;
    private int offset;
    private int totalPage;
    private int totalCount;

    public PageParameter() {
        this.currentPage = 1;
        this.pageSize = 12;
    }

    public PageParameter(Integer currentPage, Integer pageSize) {
        this.currentPage = currentPage == null || currentPage <= 0 ? 1 : currentPage;
        this.pageSize = pageSize == null || pageSize <= 0 ? 12 : pageSize;
        this.offset = (this.currentPage - 1) * this.pageSize;
    }

    public PageParameter(int currentPage, int pageSize, int totalCount) {
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.totalCount = totalCount;
        this.totalPage = (int)Math.ceil((double)totalCount / (double)pageSize);
        this.prePage = currentPage <= 1 ? 1 : currentPage - 1;
        this.nextPage = currentPage >= this.totalPage ? this.totalPage : currentPage + 1;
    }

    @Generated
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Generated
    public int getPrePage() {
        return this.prePage;
    }

    @Generated
    public int getNextPage() {
        return this.nextPage;
    }

    @Generated
    public int getPageSize() {
        return this.pageSize;
    }

    @Generated
    public int getOffset() {
        return this.offset;
    }

    @Generated
    public int getTotalPage() {
        return this.totalPage;
    }

    @Generated
    public int getTotalCount() {
        return this.totalCount;
    }

    @Generated
    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    @Generated
    public void setPrePage(int prePage) {
        this.prePage = prePage;
    }

    @Generated
    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    @Generated
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Generated
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Generated
    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    @Generated
    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageParameter)) {
            return false;
        }
        PageParameter other = (PageParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrentPage() != other.getCurrentPage()) {
            return false;
        }
        if (this.getPrePage() != other.getPrePage()) {
            return false;
        }
        if (this.getNextPage() != other.getNextPage()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getTotalPage() != other.getTotalPage()) {
            return false;
        }
        return this.getTotalCount() == other.getTotalCount();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageParameter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurrentPage();
        result = result * 59 + this.getPrePage();
        result = result * 59 + this.getNextPage();
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getOffset();
        result = result * 59 + this.getTotalPage();
        result = result * 59 + this.getTotalCount();
        return result;
    }

    @Generated
    public String toString() {
        return "PageParameter(currentPage=" + this.getCurrentPage() + ", prePage=" + this.getPrePage() + ", nextPage=" + this.getNextPage() + ", pageSize=" + this.getPageSize() + ", offset=" + this.getOffset() + ", totalPage=" + this.getTotalPage() + ", totalCount=" + this.getTotalCount() + ")";
    }
}

