/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.shenyu.admin.mapper.DashboardUserMapper;
import org.apache.shenyu.admin.mapper.PermissionMapper;
import org.apache.shenyu.admin.mapper.ResourceMapper;
import org.apache.shenyu.admin.mapper.UserRoleMapper;
import org.apache.shenyu.admin.model.custom.UserInfo;
import org.apache.shenyu.admin.model.entity.PermissionDO;
import org.apache.shenyu.admin.model.entity.UserRoleDO;
import org.apache.shenyu.admin.model.vo.PermissionMenuVO;
import org.apache.shenyu.admin.model.vo.ResourceVO;
import org.apache.shenyu.admin.service.PermissionService;
import org.apache.shenyu.admin.service.ResourceService;
import org.apache.shenyu.admin.utils.JwtUtils;
import org.apache.shenyu.common.constant.ResourceTypeConstants;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class PermissionServiceImpl
implements PermissionService {
    private final DashboardUserMapper dashboardUserMapper;
    private final UserRoleMapper userRoleMapper;
    private final PermissionMapper permissionMapper;
    private final ResourceMapper resourceMapper;
    private final ResourceService resourceService;

    @Override
    public PermissionMenuVO getPermissionMenu(String token) {
        List<ResourceVO> resourceVOList;
        UserInfo userInfo = JwtUtils.getUserInfo();
        if (!ObjectUtils.isEmpty((Object)userInfo) && CollectionUtils.isNotEmpty(resourceVOList = this.getResourceListByUserName(userInfo.getUserName()))) {
            ArrayList<PermissionMenuVO.MenuInfo> menuInfoList = new ArrayList<PermissionMenuVO.MenuInfo>();
            this.resourceService.getMenuInfo(menuInfoList, resourceVOList, null);
            return new PermissionMenuVO(menuInfoList, this.getAuthPerm(resourceVOList), this.getAllAuthPerms());
        }
        return null;
    }

    @Override
    public Set<String> getAuthPermByUserName(String userName) {
        List<ResourceVO> resourceVOList = this.getResourceListByUserName(userName);
        if (CollectionUtils.isNotEmpty(resourceVOList)) {
            return this.getAuthPerm(resourceVOList).stream().map(PermissionMenuVO.AuthPerm::getPerms).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private List<ResourceVO> getResourceListByUserName(String userName) {
        HashMap resourceMap = new HashMap();
        List<UserRoleDO> userRoleDOList = this.userRoleMapper.findByUserId(this.dashboardUserMapper.selectByUserName(userName).getId());
        for (UserRoleDO userRoleDO : userRoleDOList) {
            this.permissionMapper.findByObjectId(userRoleDO.getRoleId()).stream().map(PermissionDO::getResourceId).collect(Collectors.toList()).forEach(resource -> resourceMap.put(resource, 1));
        }
        if (MapUtils.isNotEmpty(resourceMap)) {
            return new ArrayList(resourceMap.keySet()).stream().map(resource -> ResourceVO.buildResourceVO(this.resourceMapper.selectById((String)resource))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<PermissionMenuVO.AuthPerm> getAuthPerm(List<ResourceVO> resourceVOList) {
        return resourceVOList.stream().filter(item -> item.getResourceType().equals(ResourceTypeConstants.MENU_TYPE_2)).map(PermissionMenuVO.AuthPerm::buildAuthPerm).collect(Collectors.toList());
    }

    private List<PermissionMenuVO.AuthPerm> getAllAuthPerms() {
        return this.resourceMapper.selectAll().stream().filter(item -> item.getResourceType().equals(ResourceTypeConstants.MENU_TYPE_2)).map(item -> PermissionMenuVO.AuthPerm.buildAuthPerm(ResourceVO.buildResourceVO(item))).collect(Collectors.toList());
    }

    @Generated
    public PermissionServiceImpl(DashboardUserMapper dashboardUserMapper, UserRoleMapper userRoleMapper, PermissionMapper permissionMapper, ResourceMapper resourceMapper, ResourceService resourceService) {
        this.dashboardUserMapper = dashboardUserMapper;
        this.userRoleMapper = userRoleMapper;
        this.permissionMapper = permissionMapper;
        this.resourceMapper = resourceMapper;
        this.resourceService = resourceService;
    }
}

