/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.mapper.PluginHandleMapper;
import org.apache.shenyu.admin.mapper.ShenyuDictMapper;
import org.apache.shenyu.admin.model.dto.PluginHandleDTO;
import org.apache.shenyu.admin.model.entity.PluginHandleDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.PluginHandleQuery;
import org.apache.shenyu.admin.model.vo.PluginHandleVO;
import org.apache.shenyu.admin.model.vo.ShenyuDictVO;
import org.apache.shenyu.admin.service.PluginHandleService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PluginHandleServiceImpl
implements PluginHandleService {
    private static final int SELECT_BOX_DATA_TYPE = 3;
    private final PluginHandleMapper pluginHandleMapper;
    private final ShenyuDictMapper shenyuDictMapper;

    @Override
    public CommonPager<PluginHandleVO> listByPage(PluginHandleQuery pluginHandleQuery) {
        return PageResultUtils.result(pluginHandleQuery.getPageParameter(), () -> this.pluginHandleMapper.countByQuery(pluginHandleQuery), () -> this.pluginHandleMapper.selectByQuery(pluginHandleQuery).stream().map(this::buildPluginHandleVO).collect(Collectors.toList()));
    }

    @Override
    public Integer createOrUpdate(PluginHandleDTO pluginHandleDTO) {
        PluginHandleDO pluginHandleDO = PluginHandleDO.buildPluginHandleDO(pluginHandleDTO);
        int pluginHandleCount = StringUtils.isEmpty((CharSequence)pluginHandleDTO.getId()) ? this.pluginHandleMapper.insertSelective(pluginHandleDO) : this.pluginHandleMapper.updateByPrimaryKeySelective(pluginHandleDO);
        return pluginHandleCount;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer deletePluginHandles(List<String> ids) {
        int affectedRows = 0;
        for (String id : ids) {
            affectedRows += this.pluginHandleMapper.delete(id);
        }
        return affectedRows;
    }

    @Override
    public PluginHandleVO findById(String id) {
        return this.buildPluginHandleVO(this.pluginHandleMapper.selectById(id));
    }

    @Override
    public List<PluginHandleVO> list(String pluginId, Integer type) {
        PluginHandleQuery pluginHandleQuery = PluginHandleQuery.builder().pluginId(pluginId).type(type).build();
        return this.pluginHandleMapper.selectByQuery(pluginHandleQuery).stream().map(this::buildPluginHandleVO).collect(Collectors.toList());
    }

    private PluginHandleVO buildPluginHandleVO(PluginHandleDO pluginHandleDO) {
        List dictOptions = null;
        if (pluginHandleDO.getDataType() == 3) {
            dictOptions = this.shenyuDictMapper.findByType(pluginHandleDO.getField()).stream().map(ShenyuDictVO::buildShenyuDictVO).collect(Collectors.toList());
        }
        return PluginHandleVO.buildPluginHandleVO(pluginHandleDO, dictOptions);
    }

    @Generated
    public PluginHandleServiceImpl(PluginHandleMapper pluginHandleMapper, ShenyuDictMapper shenyuDictMapper) {
        this.pluginHandleMapper = pluginHandleMapper;
        this.shenyuDictMapper = shenyuDictMapper;
    }
}

