/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.mapper.PermissionMapper;
import org.apache.shenyu.admin.mapper.ResourceMapper;
import org.apache.shenyu.admin.model.dto.PermissionDTO;
import org.apache.shenyu.admin.model.dto.ResourceDTO;
import org.apache.shenyu.admin.model.entity.PermissionDO;
import org.apache.shenyu.admin.model.entity.ResourceDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.ResourceQuery;
import org.apache.shenyu.admin.model.vo.PermissionMenuVO;
import org.apache.shenyu.admin.model.vo.ResourceVO;
import org.apache.shenyu.admin.service.ResourceService;
import org.apache.shenyu.common.enums.AdminResourceEnum;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import reactor.util.StringUtils;

@Service
public class ResourceServiceImpl
implements ResourceService {
    private final ResourceMapper resourceMapper;
    private final PermissionMapper permissionMapper;

    @Override
    public void createResource(ResourceDO resourceDO) {
        this.insertResource(resourceDO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createOrUpdate(ResourceDTO resourceDTO) {
        ResourceDO resourceDO = ResourceDO.buildResourceDO(resourceDTO);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)resourceDTO.getId())) {
            return this.insertResource(resourceDO);
        }
        return this.resourceMapper.updateSelective(resourceDO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delete(List<String> ids) {
        HashMap<String, String> deleteResourceMap = new HashMap<String, String>();
        List<ResourceVO> resourceVOList = this.resourceMapper.selectAll().stream().map(ResourceVO::buildResourceVO).collect(Collectors.toList());
        this.getDeleteResourceIds(deleteResourceMap, ids, resourceVOList);
        ArrayList<String> deleteResourceIds = new ArrayList<String>(deleteResourceMap.keySet());
        this.permissionMapper.deleteByResourceId(deleteResourceIds);
        return this.resourceMapper.delete(deleteResourceIds);
    }

    @Override
    public ResourceVO findById(String id) {
        return ResourceVO.buildResourceVO(this.resourceMapper.selectById(id));
    }

    @Override
    public ResourceVO findByTitle(String title) {
        return ResourceVO.buildResourceVO(this.resourceMapper.selectByTitle(title));
    }

    @Override
    public CommonPager<ResourceVO> listByPage(ResourceQuery resourceQuery) {
        return PageResultUtils.result(resourceQuery.getPageParameter(), () -> this.resourceMapper.countByQuery(resourceQuery), () -> this.resourceMapper.selectByQuery(resourceQuery).stream().map(ResourceVO::buildResourceVO).collect(Collectors.toList()));
    }

    @Override
    public List<PermissionMenuVO.MenuInfo> getMenuTree() {
        List<ResourceVO> resourceVOList = this.resourceMapper.selectAll().stream().map(ResourceVO::buildResourceVO).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(resourceVOList)) {
            ArrayList<PermissionMenuVO.MenuInfo> menuInfoList = new ArrayList<PermissionMenuVO.MenuInfo>();
            this.getMenuInfo(menuInfoList, resourceVOList, null);
            return menuInfoList;
        }
        return null;
    }

    @Override
    public List<ResourceVO> findByParentId(String id) {
        return this.resourceMapper.selectByParentId(id).stream().filter(item -> item.getResourceType().equals(AdminResourceEnum.THREE_MENU.getCode())).map(ResourceVO::buildResourceVO).collect(Collectors.toList());
    }

    @Override
    public void getMenuInfo(List<PermissionMenuVO.MenuInfo> menuInfoList, List<ResourceVO> metaList, PermissionMenuVO.MenuInfo menuInfo) {
        for (ResourceVO resourceVO : metaList) {
            String parentId = resourceVO.getParentId();
            PermissionMenuVO.MenuInfo tempMenuInfo = PermissionMenuVO.MenuInfo.buildMenuInfo(resourceVO);
            if (ObjectUtils.isEmpty((Object)tempMenuInfo)) continue;
            if (ObjectUtils.isEmpty((Object)menuInfo) && StringUtils.isEmpty((Object)parentId)) {
                menuInfoList.add(tempMenuInfo);
                if (!Objects.equals(resourceVO.getIsLeaf(), Boolean.FALSE)) continue;
                this.getMenuInfo(menuInfoList, metaList, tempMenuInfo);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)menuInfo) || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)parentId) || !parentId.equals(menuInfo.getId())) continue;
            menuInfo.getChildren().add(tempMenuInfo);
            if (!Objects.equals(resourceVO.getIsLeaf(), Boolean.FALSE)) continue;
            this.getMenuInfo(menuInfoList, metaList, tempMenuInfo);
        }
    }

    private void getDeleteResourceIds(Map<String, String> deleteResourceIds, List<String> resourceIds, List<ResourceVO> metaList) {
        ArrayList matchResourceIds = new ArrayList();
        resourceIds.forEach(item -> {
            matchResourceIds.clear();
            metaList.forEach(resource -> {
                if (resource.getParentId().equals(item)) {
                    matchResourceIds.add(resource.getId());
                }
                if (resource.getId().equals(item) || resource.getParentId().equals(item)) {
                    deleteResourceIds.put(resource.getId(), resource.getTitle());
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)matchResourceIds)) {
                this.getDeleteResourceIds(deleteResourceIds, matchResourceIds, metaList);
            }
        });
    }

    private int insertResource(ResourceDO resourceDO) {
        this.permissionMapper.insertSelective(PermissionDO.buildPermissionDO(PermissionDTO.builder().objectId("1346358560427216896").resourceId(resourceDO.getId()).build()));
        return this.resourceMapper.insertSelective(resourceDO);
    }

    @Generated
    public ResourceServiceImpl(ResourceMapper resourceMapper, PermissionMapper permissionMapper) {
        this.resourceMapper = resourceMapper;
        this.permissionMapper = permissionMapper;
    }
}

