/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.mapper.PermissionMapper;
import org.apache.shenyu.admin.mapper.ResourceMapper;
import org.apache.shenyu.admin.mapper.RoleMapper;
import org.apache.shenyu.admin.model.dto.PermissionDTO;
import org.apache.shenyu.admin.model.dto.RoleDTO;
import org.apache.shenyu.admin.model.entity.PermissionDO;
import org.apache.shenyu.admin.model.entity.RoleDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.PermissionQuery;
import org.apache.shenyu.admin.model.query.RoleQuery;
import org.apache.shenyu.admin.model.vo.ResourceVO;
import org.apache.shenyu.admin.model.vo.RoleEditVO;
import org.apache.shenyu.admin.model.vo.RoleVO;
import org.apache.shenyu.admin.service.RoleService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class RoleServiceImpl
implements RoleService {
    private final RoleMapper roleMapper;
    private final PermissionMapper permissionMapper;
    private final ResourceMapper resourceMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createOrUpdate(RoleDTO roleDTO) {
        RoleDO roleDO = RoleDO.buildRoleDO(roleDTO);
        if (StringUtils.isEmpty((CharSequence)roleDTO.getId())) {
            return this.roleMapper.insertSelective(roleDO);
        }
        this.manageRolePermission(roleDTO.getId(), roleDTO.getCurrentPermissionIds());
        return this.roleMapper.updateSelective(roleDO);
    }

    @Override
    public int delete(List<String> ids) {
        this.permissionMapper.deleteByObjectIds(ids);
        return this.roleMapper.delete(ids);
    }

    @Override
    public RoleEditVO findById(String id) {
        RoleVO sysRole = RoleVO.buildRoleVO(this.roleMapper.selectById(id));
        return Optional.ofNullable(sysRole).map(item -> new RoleEditVO(this.getPermissionIdsByRoleId(item.getId()), (RoleVO)item, this.getAllPermissions())).orElse(null);
    }

    @Override
    public RoleVO findByQuery(String roleName) {
        return RoleVO.buildRoleVO(this.roleMapper.findByRoleName(roleName));
    }

    @Override
    public CommonPager<RoleVO> listByPage(RoleQuery roleQuery) {
        return PageResultUtils.result(roleQuery.getPageParameter(), () -> this.roleMapper.countByQuery(roleQuery), () -> this.roleMapper.selectByQuery(roleQuery).stream().map(RoleVO::buildRoleVO).collect(Collectors.toList()));
    }

    @Override
    public List<RoleVO> selectAll() {
        return this.roleMapper.selectAll().stream().map(RoleVO::buildRoleVO).collect(Collectors.toList());
    }

    private RoleEditVO.PermissionInfo getAllPermissions() {
        List<ResourceVO> resourceVOList = this.resourceMapper.selectAll().stream().map(ResourceVO::buildResourceVO).collect(Collectors.toList());
        List<String> permissionIds = resourceVOList.stream().map(ResourceVO::getId).collect(Collectors.toList());
        ArrayList<RoleEditVO.ResourceInfo> treeList = new ArrayList<RoleEditVO.ResourceInfo>();
        this.getTreeModelList(treeList, resourceVOList, null);
        return RoleEditVO.PermissionInfo.builder().treeList(treeList).permissionIds(permissionIds).build();
    }

    private List<String> getPermissionIdsByRoleId(String roleId) {
        return this.permissionMapper.findByObjectId(roleId).stream().map(PermissionDO::getResourceId).collect(Collectors.toList());
    }

    private void getTreeModelList(List<RoleEditVO.ResourceInfo> treeList, List<ResourceVO> metaList, RoleEditVO.ResourceInfo resourceInfo) {
        for (ResourceVO resourceVO : metaList) {
            String parentId = resourceVO.getParentId();
            RoleEditVO.ResourceInfo resourceInfoItem = RoleEditVO.ResourceInfo.buildResourceInfo(resourceVO);
            if (ObjectUtils.isEmpty((Object)resourceInfo) && StringUtils.isEmpty((CharSequence)parentId)) {
                treeList.add(resourceInfoItem);
                if (!resourceInfoItem.getIsLeaf().equals(Boolean.FALSE)) continue;
                this.getTreeModelList(treeList, metaList, resourceInfoItem);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)resourceInfo) || !StringUtils.isNotEmpty((CharSequence)parentId) || !parentId.equals(resourceInfo.getId())) continue;
            resourceInfo.getChildren().add(resourceInfoItem);
            if (!resourceInfoItem.getIsLeaf().equals(Boolean.FALSE)) continue;
            this.getTreeModelList(treeList, metaList, resourceInfoItem);
        }
    }

    private List<String> getListDiff(List<String> preList, List<String> lastList) {
        if (CollectionUtils.isEmpty(lastList)) {
            return null;
        }
        if (CollectionUtils.isEmpty(preList)) {
            return lastList;
        }
        Map<String, Integer> map = preList.stream().distinct().collect(Collectors.toMap(source -> source, source -> 1));
        return lastList.stream().filter(item -> !map.containsKey(item)).collect(Collectors.toList());
    }

    private void batchSavePermission(List<PermissionDO> permissionDOList) {
        permissionDOList.forEach(this.permissionMapper::insertSelective);
    }

    private void deleteByObjectIdAndResourceId(PermissionQuery permissionQuery) {
        this.permissionMapper.deleteByObjectIdAndResourceId(permissionQuery);
    }

    private void manageRolePermission(String roleId, List<String> currentPermissionList) {
        List<String> deletePermission;
        List<String> lastPermissionList = this.permissionMapper.findByObjectId(roleId).stream().map(PermissionDO::getResourceId).collect(Collectors.toList());
        List<String> addPermission = this.getListDiff(lastPermissionList, currentPermissionList);
        if (CollectionUtils.isNotEmpty(addPermission)) {
            this.batchSavePermission(addPermission.stream().map(node -> PermissionDO.buildPermissionDO(PermissionDTO.builder().objectId(roleId).resourceId((String)node).build())).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(deletePermission = this.getListDiff(currentPermissionList, lastPermissionList))) {
            deletePermission.forEach(node -> this.deleteByObjectIdAndResourceId(new PermissionQuery(roleId, (String)node)));
        }
    }

    @Generated
    public RoleServiceImpl(RoleMapper roleMapper, PermissionMapper permissionMapper, ResourceMapper resourceMapper) {
        this.roleMapper = roleMapper;
        this.permissionMapper = permissionMapper;
        this.resourceMapper = resourceMapper;
    }
}

