/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.DataPermission;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.DataPermissionMapper;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.mapper.RuleConditionMapper;
import org.apache.shenyu.admin.mapper.RuleMapper;
import org.apache.shenyu.admin.mapper.SelectorConditionMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.DataPermissionDTO;
import org.apache.shenyu.admin.model.dto.SelectorConditionDTO;
import org.apache.shenyu.admin.model.dto.SelectorDTO;
import org.apache.shenyu.admin.model.entity.DataPermissionDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.RuleDO;
import org.apache.shenyu.admin.model.entity.SelectorConditionDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.RuleConditionQuery;
import org.apache.shenyu.admin.model.query.RuleQuery;
import org.apache.shenyu.admin.model.query.SelectorConditionQuery;
import org.apache.shenyu.admin.model.query.SelectorQuery;
import org.apache.shenyu.admin.model.vo.SelectorConditionVO;
import org.apache.shenyu.admin.model.vo.SelectorVO;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.impl.UpstreamCheckService;
import org.apache.shenyu.admin.transfer.ConditionTransfer;
import org.apache.shenyu.admin.utils.JwtUtils;
import org.apache.shenyu.common.constant.AdminConstants;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.DivideUpstream;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SelectorServiceImpl
implements SelectorService {
    private final SelectorMapper selectorMapper;
    private final SelectorConditionMapper selectorConditionMapper;
    private final PluginMapper pluginMapper;
    private final RuleMapper ruleMapper;
    private final RuleConditionMapper ruleConditionMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final DataPermissionMapper dataPermissionMapper;
    private final UpstreamCheckService upstreamCheckService;

    @Override
    public String register(SelectorDTO selectorDTO) {
        SelectorDO selectorDO = SelectorDO.buildSelectorDO(selectorDTO);
        List<SelectorConditionDTO> selectorConditionDTOs = selectorDTO.getSelectorConditions();
        if (StringUtils.isEmpty((CharSequence)selectorDTO.getId())) {
            this.selectorMapper.insertSelective(selectorDO);
            selectorConditionDTOs.forEach(selectorConditionDTO -> {
                selectorConditionDTO.setSelectorId(selectorDO.getId());
                this.selectorConditionMapper.insertSelective(SelectorConditionDO.buildSelectorConditionDO(selectorConditionDTO));
            });
        }
        this.publishEvent(selectorDO, selectorConditionDTOs);
        return selectorDO.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createOrUpdate(SelectorDTO selectorDTO) {
        int selectorCount;
        SelectorDO selectorDO = SelectorDO.buildSelectorDO(selectorDTO);
        List<SelectorConditionDTO> selectorConditionDTOs = selectorDTO.getSelectorConditions();
        if (StringUtils.isEmpty((CharSequence)selectorDTO.getId())) {
            selectorCount = this.selectorMapper.insertSelective(selectorDO);
            selectorConditionDTOs.forEach(selectorConditionDTO -> {
                selectorConditionDTO.setSelectorId(selectorDO.getId());
                this.selectorConditionMapper.insertSelective(SelectorConditionDO.buildSelectorConditionDO(selectorConditionDTO));
            });
            if (this.dataPermissionMapper.listByUserId(JwtUtils.getUserInfo().getUserId()).size() > 0) {
                DataPermissionDTO dataPermissionDTO = new DataPermissionDTO();
                dataPermissionDTO.setUserId(JwtUtils.getUserInfo().getUserId());
                dataPermissionDTO.setDataId(selectorDO.getId());
                dataPermissionDTO.setDataType(AdminConstants.SELECTOR_DATA_TYPE);
                this.dataPermissionMapper.insertSelective(DataPermissionDO.buildPermissionDO(dataPermissionDTO));
            }
        } else {
            selectorCount = this.selectorMapper.updateSelective(selectorDO);
            this.selectorConditionMapper.deleteByQuery(new SelectorConditionQuery(selectorDO.getId()));
            selectorConditionDTOs.forEach(selectorConditionDTO -> {
                selectorConditionDTO.setSelectorId(selectorDO.getId());
                SelectorConditionDO selectorConditionDO = SelectorConditionDO.buildSelectorConditionDO(selectorConditionDTO);
                this.selectorConditionMapper.insertSelective(selectorConditionDO);
            });
        }
        this.publishEvent(selectorDO, selectorConditionDTOs);
        this.updateDivideUpstream(selectorDO);
        return selectorCount;
    }

    @Override
    public int updateSelective(SelectorDO selectorDO) {
        return this.selectorMapper.updateSelective(selectorDO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delete(List<String> ids) {
        for (String id : ids) {
            SelectorDO selectorDO = this.selectorMapper.selectById(id);
            PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
            this.selectorMapper.delete(id);
            this.selectorConditionMapper.deleteByQuery(new SelectorConditionQuery(id));
            this.dataPermissionMapper.deleteByDataId(id);
            if (PluginEnum.DIVIDE.getName().equals(pluginDO.getName())) {
                UpstreamCheckService.removeByKey(selectorDO.getName());
            }
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.DELETE, Collections.singletonList(SelectorDO.transFrom(selectorDO, pluginDO.getName(), null))));
            List<RuleDO> ruleDOList = this.ruleMapper.selectByQuery(new RuleQuery(id, null, null));
            if (!CollectionUtils.isNotEmpty(ruleDOList)) continue;
            for (RuleDO ruleDO : ruleDOList) {
                this.ruleMapper.delete(ruleDO.getId());
                this.ruleConditionMapper.deleteByQuery(new RuleConditionQuery(ruleDO.getId()));
                this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.RULE, DataEventTypeEnum.DELETE, Collections.singletonList(RuleDO.transFrom(ruleDO, pluginDO.getName(), null))));
            }
        }
        return ids.size();
    }

    @Override
    public SelectorVO findById(String id) {
        return SelectorVO.buildSelectorVO(this.selectorMapper.selectById(id), this.selectorConditionMapper.selectByQuery(new SelectorConditionQuery(id)).stream().map(SelectorConditionVO::buildSelectorConditionVO).collect(Collectors.toList()));
    }

    @Override
    public SelectorDO findByName(String name) {
        return this.selectorMapper.selectByName(name);
    }

    @Override
    public SelectorData buildByName(String name) {
        SelectorDO selectorDO = this.selectorMapper.selectByName(name);
        return this.buildSelectorData(selectorDO);
    }

    @Override
    @DataPermission(dataType="selector")
    public CommonPager<SelectorVO> listByPage(SelectorQuery selectorQuery) {
        return PageResultUtils.result(selectorQuery.getPageParameter(), () -> this.selectorMapper.countByQuery(selectorQuery), () -> this.selectorMapper.selectByQuery(selectorQuery).stream().map(SelectorVO::buildSelectorVO).collect(Collectors.toList()));
    }

    @Override
    public List<SelectorData> findByPluginId(String pluginId) {
        return this.selectorMapper.findByPluginId(pluginId).stream().map(this::buildSelectorData).collect(Collectors.toList());
    }

    @Override
    public List<SelectorData> listAll() {
        return this.selectorMapper.selectAll().stream().filter(Objects::nonNull).map(this::buildSelectorData).collect(Collectors.toList());
    }

    @Override
    public String handlerSelectorNeedUpstreamCheck(MetaDataRegisterDTO dto, String rpcType) {
        String selectorId;
        String contextPath = dto.getContextPath();
        if (StringUtils.isEmpty((CharSequence)contextPath)) {
            contextPath = this.buildContextPath(dto.getPath());
        }
        SelectorDO selectorDO = this.selectorMapper.selectByName(contextPath);
        String uri = String.join((CharSequence)":", dto.getHost(), String.valueOf(dto.getPort()));
        if (Objects.isNull(selectorDO)) {
            selectorId = this.registerPluginSelector(contextPath, uri, rpcType);
        } else {
            String handleAdd;
            selectorId = selectorDO.getId();
            String handle = selectorDO.getHandle();
            DivideUpstream addDivideUpstream = this.buildDivideUpstream(uri);
            SelectorData selectorData = this.buildByName(contextPath);
            this.upstreamCheckService.fetchUpstreamData();
            if (StringUtils.isBlank((CharSequence)handle)) {
                handleAdd = GsonUtils.getInstance().toJson(Collections.singletonList(addDivideUpstream));
            } else {
                List exist = GsonUtils.getInstance().fromList(handle, DivideUpstream.class);
                for (DivideUpstream upstream : exist) {
                    if (!upstream.getUpstreamUrl().equals(addDivideUpstream.getUpstreamUrl())) continue;
                    return selectorId;
                }
                exist.add(addDivideUpstream);
                handleAdd = GsonUtils.getInstance().toJson((Object)exist);
            }
            selectorDO.setHandle(handleAdd);
            selectorData.setHandle(handleAdd);
            this.selectorMapper.updateSelective(selectorDO);
            this.upstreamCheckService.submit(contextPath, addDivideUpstream);
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.UPDATE, Collections.singletonList(selectorData)));
        }
        return selectorId;
    }

    private void publishEvent(SelectorDO selectorDO, List<SelectorConditionDTO> selectorConditionDTOs) {
        PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
        List<ConditionData> conditionDataList = selectorConditionDTOs.stream().map(ConditionTransfer.INSTANCE::mapToSelectorDTO).collect(Collectors.toList());
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.UPDATE, Collections.singletonList(SelectorDO.transFrom(selectorDO, pluginDO.getName(), conditionDataList))));
    }

    private SelectorData buildSelectorData(SelectorDO selectorDO) {
        List<ConditionData> conditionDataList = ConditionTransfer.INSTANCE.mapToSelectorDOS(this.selectorConditionMapper.selectByQuery(new SelectorConditionQuery(selectorDO.getId())));
        PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
        if (Objects.isNull(pluginDO)) {
            return null;
        }
        return SelectorDO.transFrom(selectorDO, pluginDO.getName(), conditionDataList);
    }

    private void updateDivideUpstream(SelectorDO selectorDO) {
        PluginDO pluginDO = this.pluginMapper.selectByName(PluginEnum.DIVIDE.getName());
        if (Objects.nonNull(pluginDO) && pluginDO.getId().equals(selectorDO.getPluginId())) {
            String selectorName = selectorDO.getName();
            String handle = selectorDO.getHandle();
            if (StringUtils.isNotBlank((CharSequence)handle)) {
                List existDivideUpstreams = GsonUtils.getInstance().fromList(handle, DivideUpstream.class);
                this.upstreamCheckService.replace(selectorName, existDivideUpstreams);
            }
        }
    }

    private String registerPluginSelector(String contextPath, String uri, String rpcType) {
        SelectorDTO selectorDTO = this.registerSelector(contextPath, this.pluginMapper.selectByName(rpcType).getId());
        DivideUpstream divideUpstream = this.buildDivideUpstream(uri);
        String handler = GsonUtils.getInstance().toJson(Collections.singletonList(divideUpstream));
        selectorDTO.setHandle(handler);
        this.upstreamCheckService.submit(selectorDTO.getName(), divideUpstream);
        return this.register(selectorDTO);
    }

    private SelectorDTO registerSelector(String contextPath, String pluginId) {
        SelectorDTO selectorDTO = this.buildDefaultSelectorDTO(contextPath);
        selectorDTO.setPluginId(pluginId);
        selectorDTO.setSelectorConditions(this.buildDefaultSelectorConditionDTO(contextPath));
        return selectorDTO;
    }

    private SelectorDTO buildDefaultSelectorDTO(String name) {
        return SelectorDTO.builder().name(name).type(SelectorTypeEnum.CUSTOM_FLOW.getCode()).matchMode(MatchModeEnum.AND.getCode()).enabled(Boolean.TRUE).loged(Boolean.TRUE).continued(Boolean.TRUE).sort(1).build();
    }

    private List<SelectorConditionDTO> buildDefaultSelectorConditionDTO(String contextPath) {
        SelectorConditionDTO selectorConditionDTO = new SelectorConditionDTO();
        selectorConditionDTO.setParamType(ParamTypeEnum.URI.getName());
        selectorConditionDTO.setParamName("/");
        selectorConditionDTO.setOperator(OperatorEnum.MATCH.getAlias());
        selectorConditionDTO.setParamValue(contextPath + "/**");
        return Collections.singletonList(selectorConditionDTO);
    }

    private String buildContextPath(String path) {
        String split = "/";
        String[] splitList = StringUtils.split((String)path, (String)split);
        if (splitList.length != 0) {
            return split.concat(splitList[0]);
        }
        return split;
    }

    private DivideUpstream buildDivideUpstream(String uri) {
        return DivideUpstream.builder().upstreamHost("localhost").protocol("http://").upstreamUrl(uri).weight(50).build();
    }

    @Generated
    public SelectorServiceImpl(SelectorMapper selectorMapper, SelectorConditionMapper selectorConditionMapper, PluginMapper pluginMapper, RuleMapper ruleMapper, RuleConditionMapper ruleConditionMapper, ApplicationEventPublisher eventPublisher, DataPermissionMapper dataPermissionMapper, UpstreamCheckService upstreamCheckService) {
        this.selectorMapper = selectorMapper;
        this.selectorConditionMapper = selectorConditionMapper;
        this.pluginMapper = pluginMapper;
        this.ruleMapper = ruleMapper;
        this.ruleConditionMapper = ruleConditionMapper;
        this.eventPublisher = eventPublisher;
        this.dataPermissionMapper = dataPermissionMapper;
        this.upstreamCheckService = upstreamCheckService;
    }
}

