/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.MetaDataMapper;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.mapper.RuleMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.RuleConditionDTO;
import org.apache.shenyu.admin.model.dto.RuleDTO;
import org.apache.shenyu.admin.model.dto.SelectorConditionDTO;
import org.apache.shenyu.admin.model.dto.SelectorDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.RuleDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.service.RuleService;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.ShenyuClientRegisterService;
import org.apache.shenyu.admin.service.impl.UpstreamCheckService;
import org.apache.shenyu.admin.transfer.MetaDataTransfer;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.DivideUpstream;
import org.apache.shenyu.common.dto.convert.rule.RuleHandle;
import org.apache.shenyu.common.dto.convert.rule.RuleHandleFactory;
import org.apache.shenyu.common.dto.convert.selector.SpringCloudSelectorHandle;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShenyuClientRegisterServiceImpl
implements ShenyuClientRegisterService {
    private static final String CONTEXT_PATH_NAME_PREFIX = "/context-path";
    private final MetaDataMapper metaDataMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final SelectorService selectorService;
    private final RuleService ruleService;
    private final RuleMapper ruleMapper;
    private final UpstreamCheckService upstreamCheckService;
    private final SelectorMapper selectorMapper;
    private final PluginMapper pluginMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public synchronized String registerSpringMvc(MetaDataRegisterDTO dto) {
        MetaDataDO exist;
        if (dto.isRegisterMetaData() && Objects.isNull(exist = this.metaDataMapper.findByPath(dto.getPath()))) {
            this.saveSpringMvcMetaData(dto);
        }
        String selectorId = this.handlerSelector(dto);
        this.handlerSpringMvcRule(selectorId, dto);
        String contextPath = dto.getContextPath();
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            this.registerContextPathPlugin(contextPath);
        }
        return "success";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public synchronized String registerSpringCloud(MetaDataRegisterDTO dto) {
        MetaDataDO metaDataDO = this.metaDataMapper.findByPath(dto.getContextPath() + "/**");
        if (Objects.isNull(metaDataDO)) {
            this.saveSpringCloudMetaData(dto);
        }
        String selectorId = this.handlerSpringCloudSelector(dto);
        this.handlerSpringCloudRule(selectorId, dto);
        String contextPath = dto.getContextPath();
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            this.registerContextPathPlugin(contextPath);
        }
        return "success";
    }

    private void registerContextPathPlugin(String contextPath) {
        String name = CONTEXT_PATH_NAME_PREFIX + contextPath;
        SelectorDO selectorDO = this.selectorService.findByName(name);
        if (Objects.isNull(selectorDO)) {
            String contextPathSelectorId = this.registerContextPathSelector(contextPath, name);
            RuleDO ruleDO = this.ruleMapper.findByName(name);
            if (Objects.isNull(ruleDO)) {
                this.registerRule(contextPathSelectorId, contextPath + "/**", PluginEnum.CONTEXT_PATH.getName(), name);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public synchronized String registerDubbo(MetaDataRegisterDTO dto) {
        MetaDataDO exist = this.metaDataMapper.findByPath(dto.getPath());
        this.saveOrUpdateMetaData(exist, dto);
        String selectorId = this.handlerDubboSelector(dto);
        this.handlerDubboRule(selectorId, dto);
        return "success";
    }

    @Override
    public synchronized String registerSofa(MetaDataRegisterDTO dto) {
        MetaDataDO metaDataDO = this.metaDataMapper.findByPath(dto.getPath());
        if (!(!Objects.nonNull(metaDataDO) || metaDataDO.getMethodName().equals(dto.getMethodName()) && metaDataDO.getServiceName().equals(dto.getServiceName()))) {
            return "you path already exist!";
        }
        MetaDataDO exist = this.metaDataMapper.findByServiceNameAndMethod(dto.getServiceName(), dto.getMethodName());
        this.saveOrUpdateMetaData(exist, dto);
        String selectorId = this.handlerSofaSelector(dto);
        this.handlerSofaRule(selectorId, dto, exist);
        return "success";
    }

    @Override
    public synchronized String registerTars(MetaDataRegisterDTO dto) {
        MetaDataDO byPath = this.metaDataMapper.findByPath(dto.getPath());
        if (!(!Objects.nonNull(byPath) || byPath.getMethodName().equals(dto.getMethodName()) && byPath.getServiceName().equals(dto.getServiceName()))) {
            return "you path already exist!";
        }
        MetaDataDO exist = this.metaDataMapper.findByServiceNameAndMethod(dto.getServiceName(), dto.getMethodName());
        this.saveOrUpdateMetaData(exist, dto);
        String selectorId = this.handlerSelector(dto);
        this.handlerTarsRule(selectorId, dto, exist);
        return "success";
    }

    @Override
    public synchronized String registerGrpc(MetaDataRegisterDTO dto) {
        MetaDataDO exist = this.metaDataMapper.findByPath(dto.getPath());
        this.saveOrUpdateMetaData(exist, dto);
        String selectorId = this.handlerSelector(dto);
        this.handlerGrpcRule(selectorId, dto, exist);
        return "success";
    }

    @Override
    public String registerMotan(MetaDataRegisterDTO dto) {
        MetaDataDO exist = this.metaDataMapper.findByPath(dto.getPath());
        this.saveOrUpdateMetaData(exist, dto);
        String selectorId = this.handlerSelector(dto);
        this.handlerMotanRule(selectorId, dto, exist);
        return "success";
    }

    private String handlerDubboSelector(MetaDataRegisterDTO metaDataDTO) {
        return this.getString(metaDataDTO);
    }

    private String getString(MetaDataRegisterDTO metaDataDTO) {
        SelectorDO selectorDO = this.selectorService.findByName(metaDataDTO.getContextPath());
        String selectorId = Objects.isNull(selectorDO) ? this.registerSelector(metaDataDTO.getContextPath(), metaDataDTO.getRpcType(), metaDataDTO.getAppName(), "") : selectorDO.getId();
        return selectorId;
    }

    private void handlerDubboRule(String selectorId, MetaDataRegisterDTO metaDataDTO) {
        RuleDO existRule = this.ruleMapper.findByName(metaDataDTO.getPath());
        if (Objects.isNull(existRule)) {
            this.registerRule(selectorId, metaDataDTO.getPath(), PluginEnum.DUBBO.getName(), metaDataDTO.getRuleName());
        }
    }

    private String handlerTarsSelector(MetaDataRegisterDTO metaDataDTO) {
        return this.getString(metaDataDTO);
    }

    private void handlerTarsRule(String selectorId, MetaDataRegisterDTO metaDataDTO, MetaDataDO exist) {
        RuleDO existRule = this.ruleMapper.findByName(metaDataDTO.getPath());
        if (Objects.isNull(exist) || Objects.isNull(existRule)) {
            this.registerRule(selectorId, metaDataDTO.getPath(), PluginEnum.TARS.getName(), metaDataDTO.getRuleName());
        }
    }

    private String handlerSofaSelector(MetaDataRegisterDTO metaDataDTO) {
        return this.getString(metaDataDTO);
    }

    private void handlerSofaRule(String selectorId, MetaDataRegisterDTO metaDataDTO, MetaDataDO exist) {
        RuleDO existRule = this.ruleMapper.findByName(metaDataDTO.getPath());
        if (Objects.isNull(exist) || Objects.isNull(existRule)) {
            this.registerRule(selectorId, metaDataDTO.getPath(), PluginEnum.SOFA.getName(), metaDataDTO.getRuleName());
        }
    }

    private String handlerGrpcSelector(MetaDataRegisterDTO metaDataDTO) {
        return this.getString(metaDataDTO);
    }

    private void handlerGrpcRule(String selectorId, MetaDataRegisterDTO metaDataDTO, MetaDataDO exist) {
        RuleDO existRule = this.ruleMapper.findByName(metaDataDTO.getPath());
        if (Objects.isNull(exist) || Objects.isNull(existRule)) {
            this.registerRule(selectorId, metaDataDTO.getPath(), PluginEnum.GRPC.getName(), metaDataDTO.getRuleName());
        }
    }

    private void handlerMotanRule(String selectorId, MetaDataRegisterDTO metaDataDTO, MetaDataDO exist) {
        RuleDO existRule = this.ruleMapper.findByName(metaDataDTO.getPath());
        if (Objects.isNull(exist) || Objects.isNull(existRule)) {
            this.registerRule(selectorId, metaDataDTO.getPath(), PluginEnum.MOTAN.getName(), metaDataDTO.getRuleName());
        }
    }

    private void saveSpringMvcMetaData(MetaDataRegisterDTO dto) {
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        BaseDO metaDataDO = ((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)((BaseDO.BaseDOBuilder)((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)MetaDataDO.builder().appName(dto.getAppName())).path(dto.getPath())).pathDesc(dto.getPathDesc())).rpcType(dto.getRpcType())).enabled(dto.isEnabled())).id(UUIDUtils.getInstance().generateShortUuid())).dateCreated(currentTime)).dateUpdated(currentTime)).build();
        this.metaDataMapper.insert((MetaDataDO)metaDataDO);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.META_DATA, DataEventTypeEnum.CREATE, Collections.singletonList(MetaDataTransfer.INSTANCE.mapToData((MetaDataDO)metaDataDO))));
    }

    private void saveSpringCloudMetaData(MetaDataRegisterDTO dto) {
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        BaseDO metaDataDO = ((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)((BaseDO.BaseDOBuilder)((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)MetaDataDO.builder().appName(dto.getAppName())).path(dto.getContextPath() + "/**")).pathDesc(dto.getAppName() + "spring cloud meta data info")).serviceName(dto.getAppName())).methodName(dto.getContextPath())).rpcType(dto.getRpcType())).enabled(dto.isEnabled())).id(UUIDUtils.getInstance().generateShortUuid())).dateCreated(currentTime)).dateUpdated(currentTime)).build();
        this.metaDataMapper.insert((MetaDataDO)metaDataDO);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.META_DATA, DataEventTypeEnum.CREATE, Collections.singletonList(MetaDataTransfer.INSTANCE.mapToData((MetaDataDO)metaDataDO))));
    }

    private void saveOrUpdateMetaData(MetaDataDO exist, MetaDataRegisterDTO metaDataDTO) {
        DataEventTypeEnum eventType;
        MetaDataDO metaDataDO = MetaDataTransfer.INSTANCE.mapRegisterDTOToEntity(metaDataDTO);
        if (Objects.isNull(exist)) {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            metaDataDO.setId(UUIDUtils.getInstance().generateShortUuid());
            metaDataDO.setDateCreated(currentTime);
            metaDataDO.setDateUpdated(currentTime);
            this.metaDataMapper.insert(metaDataDO);
            eventType = DataEventTypeEnum.CREATE;
        } else {
            metaDataDO.setId(exist.getId());
            this.metaDataMapper.update(metaDataDO);
            eventType = DataEventTypeEnum.UPDATE;
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.META_DATA, eventType, Collections.singletonList(MetaDataTransfer.INSTANCE.mapToData(metaDataDO))));
    }

    private String handlerSelector(MetaDataRegisterDTO dto) {
        String selectorId;
        String contextPath = dto.getContextPath();
        if (StringUtils.isEmpty((CharSequence)contextPath)) {
            contextPath = this.buildContextPath(dto.getPath());
        }
        SelectorDO selectorDO = this.selectorService.findByName(contextPath);
        String uri = String.join((CharSequence)":", dto.getHost(), String.valueOf(dto.getPort()));
        if (Objects.isNull(selectorDO)) {
            selectorId = this.registerSelector(contextPath, dto.getRpcType(), dto.getAppName(), uri);
        } else {
            String handleAdd;
            selectorId = selectorDO.getId();
            String handle = selectorDO.getHandle();
            DivideUpstream addDivideUpstream = this.buildDivideUpstream(uri);
            SelectorData selectorData = this.selectorService.buildByName(contextPath);
            this.upstreamCheckService.fetchUpstreamData();
            if (StringUtils.isBlank((CharSequence)handle)) {
                handleAdd = GsonUtils.getInstance().toJson(Collections.singletonList(addDivideUpstream));
            } else {
                List exist = GsonUtils.getInstance().fromList(handle, DivideUpstream.class);
                for (DivideUpstream upstream : exist) {
                    if (!upstream.getUpstreamUrl().equals(addDivideUpstream.getUpstreamUrl())) continue;
                    return selectorId;
                }
                exist.add(addDivideUpstream);
                handleAdd = GsonUtils.getInstance().toJson((Object)exist);
            }
            selectorDO.setHandle(handleAdd);
            selectorData.setHandle(handleAdd);
            this.selectorMapper.updateSelective(selectorDO);
            this.upstreamCheckService.submit(contextPath, addDivideUpstream);
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.UPDATE, Collections.singletonList(selectorData)));
        }
        return selectorId;
    }

    private String buildContextPath(String path) {
        String split = "/";
        String[] splitList = StringUtils.split((String)path, (String)split);
        if (splitList.length != 0) {
            return split.concat(splitList[0]);
        }
        return split;
    }

    private void handlerSpringMvcRule(String selectorId, MetaDataRegisterDTO dto) {
        RuleDO ruleDO = this.ruleMapper.findByName(dto.getRuleName());
        if (Objects.isNull(ruleDO)) {
            this.registerRule(selectorId, dto.getPath(), PluginEnum.DIVIDE.getName(), dto.getRuleName());
        }
    }

    private String handlerSpringCloudSelector(MetaDataRegisterDTO dto) {
        SelectorDO selectorDO;
        String contextPath = dto.getContextPath();
        if (StringUtils.isEmpty((CharSequence)contextPath)) {
            contextPath = this.buildContextPath(dto.getPath());
        }
        if (Objects.isNull(selectorDO = this.selectorService.findByName(contextPath))) {
            return this.registerSelector(contextPath, dto.getRpcType(), dto.getAppName(), "");
        }
        return selectorDO.getId();
    }

    private void handlerSpringCloudRule(String selectorId, MetaDataRegisterDTO dto) {
        RuleDO ruleDO = this.ruleMapper.findByName(dto.getRuleName());
        if (Objects.isNull(ruleDO)) {
            this.registerRule(selectorId, dto.getPath(), PluginEnum.SPRING_CLOUD.getName(), dto.getRuleName());
        }
    }

    private String registerSelector(String contextPath, String rpcType, String appName, String uri) {
        SelectorDTO selectorDTO = this.buildDefaultSelectorDTO(contextPath);
        if (RpcTypeEnum.DUBBO.getName().equals(rpcType)) {
            selectorDTO.setPluginId(this.getPluginId(PluginEnum.DUBBO.getName()));
        } else if (RpcTypeEnum.SPRING_CLOUD.getName().equals(rpcType)) {
            selectorDTO.setPluginId(this.getPluginId(PluginEnum.SPRING_CLOUD.getName()));
            selectorDTO.setHandle(GsonUtils.getInstance().toJson((Object)this.buildSpringCloudSelectorHandle(appName)));
        } else if (RpcTypeEnum.SOFA.getName().equals(rpcType)) {
            selectorDTO.setPluginId(this.getPluginId(PluginEnum.SOFA.getName()));
            selectorDTO.setHandle(appName);
        } else {
            if (RpcTypeEnum.TARS.getName().equals(rpcType) || RpcTypeEnum.GRPC.getName().equals(rpcType)) {
                selectorDTO.setPluginId(this.getPluginId(rpcType));
            } else {
                selectorDTO.setPluginId(this.getPluginId(PluginEnum.DIVIDE.getName()));
            }
            DivideUpstream divideUpstream = this.buildDivideUpstream(uri);
            String handler = GsonUtils.getInstance().toJson(Collections.singletonList(divideUpstream));
            selectorDTO.setHandle(handler);
            this.upstreamCheckService.submit(selectorDTO.getName(), divideUpstream);
        }
        selectorDTO.setSelectorConditions(this.buildDefaultSelectorConditionDTO(contextPath));
        return this.selectorService.register(selectorDTO);
    }

    private String registerContextPathSelector(String contextPath, String name) {
        SelectorDTO selectorDTO = this.buildDefaultSelectorDTO(name);
        selectorDTO.setPluginId(this.getPluginId(PluginEnum.CONTEXT_PATH.getName()));
        selectorDTO.setSelectorConditions(this.buildDefaultSelectorConditionDTO(contextPath));
        return this.selectorService.register(selectorDTO);
    }

    private SelectorDTO buildDefaultSelectorDTO(String name) {
        return SelectorDTO.builder().name(name).type(SelectorTypeEnum.CUSTOM_FLOW.getCode()).matchMode(MatchModeEnum.AND.getCode()).enabled(Boolean.TRUE).loged(Boolean.TRUE).continued(Boolean.TRUE).sort(1).build();
    }

    private List<SelectorConditionDTO> buildDefaultSelectorConditionDTO(String contextPath) {
        SelectorConditionDTO selectorConditionDTO = new SelectorConditionDTO();
        selectorConditionDTO.setParamType(ParamTypeEnum.URI.getName());
        selectorConditionDTO.setParamName("/");
        selectorConditionDTO.setOperator(OperatorEnum.MATCH.getAlias());
        selectorConditionDTO.setParamValue(contextPath + "/**");
        return Collections.singletonList(selectorConditionDTO);
    }

    private SpringCloudSelectorHandle buildSpringCloudSelectorHandle(String serviceId) {
        return SpringCloudSelectorHandle.builder().serviceId(serviceId).build();
    }

    private String getPluginId(String pluginName) {
        PluginDO pluginDO = this.pluginMapper.selectByName(pluginName);
        Objects.requireNonNull(pluginDO);
        return pluginDO.getId();
    }

    private void registerRule(String selectorId, String path, String pluginName, String ruleName) {
        RuleHandle ruleHandle = pluginName.equals(PluginEnum.CONTEXT_PATH.getName()) ? RuleHandleFactory.ruleHandle((String)pluginName, (String)this.buildContextPath(path)) : RuleHandleFactory.ruleHandle((String)pluginName, (String)path);
        RuleDTO ruleDTO = RuleDTO.builder().selectorId(selectorId).name(ruleName).matchMode(MatchModeEnum.AND.getCode()).enabled(Boolean.TRUE).loged(Boolean.TRUE).sort(1).handle(ruleHandle.toJson()).build();
        RuleConditionDTO ruleConditionDTO = RuleConditionDTO.builder().paramType(ParamTypeEnum.URI.getName()).paramName("/").paramValue(path).build();
        if (path.indexOf("*") > 1) {
            ruleConditionDTO.setOperator(OperatorEnum.MATCH.getAlias());
        } else {
            ruleConditionDTO.setOperator(OperatorEnum.EQ.getAlias());
        }
        ruleDTO.setRuleConditions(Collections.singletonList(ruleConditionDTO));
        this.ruleService.register(ruleDTO, ruleName, false);
    }

    @Override
    public String registerURI(String contextPath, List<String> uriList) {
        SelectorDO selector = this.selectorService.findByName(contextPath);
        SelectorData selectorData = this.selectorService.buildByName(contextPath);
        String handler = GsonUtils.getInstance().toJson(this.buildDivideUpstreamList(uriList));
        selector.setHandle(handler);
        selectorData.setHandle(handler);
        this.selectorMapper.updateSelective(selector);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.UPDATE, Collections.singletonList(selectorData)));
        return "success";
    }

    private List<DivideUpstream> buildDivideUpstreamList(List<String> uriList) {
        return uriList.stream().map(this::buildDivideUpstream).collect(Collectors.toList());
    }

    private DivideUpstream buildDivideUpstream(String uri) {
        return DivideUpstream.builder().upstreamHost("localhost").protocol("http://").upstreamUrl(uri).weight(50).build();
    }

    @Generated
    public ShenyuClientRegisterServiceImpl(MetaDataMapper metaDataMapper, ApplicationEventPublisher eventPublisher, SelectorService selectorService, RuleService ruleService, RuleMapper ruleMapper, UpstreamCheckService upstreamCheckService, SelectorMapper selectorMapper, PluginMapper pluginMapper) {
        this.metaDataMapper = metaDataMapper;
        this.eventPublisher = eventPublisher;
        this.selectorService = selectorService;
        this.ruleService = ruleService;
        this.ruleMapper = ruleMapper;
        this.upstreamCheckService = upstreamCheckService;
        this.selectorMapper = selectorMapper;
        this.pluginMapper = pluginMapper;
    }
}

