/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.mapper.ShenyuDictMapper;
import org.apache.shenyu.admin.model.dto.ShenyuDictDTO;
import org.apache.shenyu.admin.model.entity.ShenyuDictDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.ShenyuDictQuery;
import org.apache.shenyu.admin.model.vo.ShenyuDictVO;
import org.apache.shenyu.admin.service.ShenyuDictService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShenyuDictServiceImpl
implements ShenyuDictService {
    private final ShenyuDictMapper shenyuDictMapper;

    @Override
    public CommonPager<ShenyuDictVO> listByPage(ShenyuDictQuery shenyuDictQuery) {
        return PageResultUtils.result(shenyuDictQuery.getPageParameter(), () -> this.shenyuDictMapper.countByQuery(shenyuDictQuery), () -> this.shenyuDictMapper.selectByQuery(shenyuDictQuery).stream().map(ShenyuDictVO::buildShenyuDictVO).collect(Collectors.toList()));
    }

    @Override
    public Integer createOrUpdate(ShenyuDictDTO shenyuDictDTO) {
        ShenyuDictDO shenyuDictDO = ShenyuDictDO.buildShenyuDictDO(shenyuDictDTO);
        int count = StringUtils.isEmpty((CharSequence)shenyuDictDTO.getId()) ? this.shenyuDictMapper.insertSelective(shenyuDictDO) : this.shenyuDictMapper.updateByPrimaryKeySelective(shenyuDictDO);
        return count;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer deleteShenyuDicts(List<String> ids) {
        int affectedRows = 0;
        for (String id : ids) {
            affectedRows += this.shenyuDictMapper.delete(id);
        }
        return affectedRows;
    }

    @Override
    public Integer enabled(List<String> ids, Boolean enabled) {
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        return this.shenyuDictMapper.enabled(ids, enabled);
    }

    @Override
    public ShenyuDictVO findById(String id) {
        return ShenyuDictVO.buildShenyuDictVO(this.shenyuDictMapper.selectById(id));
    }

    @Override
    public List<ShenyuDictVO> list(String type) {
        ShenyuDictQuery shenyuDictQuery = new ShenyuDictQuery();
        shenyuDictQuery.setType(type);
        return this.shenyuDictMapper.selectByQuery(shenyuDictQuery).stream().map(ShenyuDictVO::buildShenyuDictVO).collect(Collectors.toList());
    }

    @Generated
    public ShenyuDictServiceImpl(ShenyuDictMapper shenyuDictMapper) {
        this.shenyuDictMapper = shenyuDictMapper;
    }
}

