/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.model.vo.PluginVO;
import org.apache.shenyu.admin.service.AppAuthService;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.PluginService;
import org.apache.shenyu.admin.service.RuleService;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.SyncDataService;
import org.apache.shenyu.admin.transfer.PluginTransfer;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class SyncDataServiceImpl
implements SyncDataService {
    private final AppAuthService appAuthService;
    private final PluginService pluginService;
    private final SelectorService selectorService;
    private final RuleService ruleService;
    private final ApplicationEventPublisher eventPublisher;
    private final MetaDataService metaDataService;

    @Override
    public boolean syncAll(DataEventTypeEnum type) {
        this.appAuthService.syncData();
        List<PluginData> pluginDataList = this.pluginService.listAll();
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, type, pluginDataList));
        List<SelectorData> selectorDataList = this.selectorService.listAll();
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, type, selectorDataList));
        List<RuleData> ruleDataList = this.ruleService.listAll();
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.RULE, type, ruleDataList));
        this.metaDataService.syncData();
        return true;
    }

    @Override
    public boolean syncPluginData(String pluginId) {
        PluginVO pluginVO = this.pluginService.findById(pluginId);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.UPDATE, Collections.singletonList(PluginTransfer.INSTANCE.mapDataTOVO(pluginVO))));
        List<SelectorData> selectorDataList = this.selectorService.findByPluginId(pluginId);
        if (CollectionUtils.isNotEmpty(selectorDataList)) {
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.REFRESH, selectorDataList));
            ArrayList<RuleData> allRuleDataList = new ArrayList<RuleData>();
            for (SelectorData selectData : selectorDataList) {
                List<RuleData> ruleDataList = this.ruleService.findBySelectorId(selectData.getId());
                allRuleDataList.addAll(ruleDataList);
            }
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.RULE, DataEventTypeEnum.REFRESH, allRuleDataList));
        }
        return true;
    }

    @Generated
    public SyncDataServiceImpl(AppAuthService appAuthService, PluginService pluginService, SelectorService selectorService, RuleService ruleService, ApplicationEventPublisher eventPublisher, MetaDataService metaDataService) {
        this.appAuthService = appAuthService;
        this.pluginService = pluginService;
        this.selectorService = selectorService;
        this.ruleService = ruleService;
        this.eventPublisher = eventPublisher;
        this.metaDataService = metaDataService;
    }
}

