/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.mapper.SelectorConditionMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.query.SelectorConditionQuery;
import org.apache.shenyu.admin.transfer.ConditionTransfer;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.DivideUpstream;
import org.apache.shenyu.common.dto.convert.ZombieUpstream;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.UpstreamCheckUtils;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class UpstreamCheckService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpstreamCheckService.class);
    private static final Map<String, List<DivideUpstream>> UPSTREAM_MAP = Maps.newConcurrentMap();
    private static final Set<ZombieUpstream> ZOMBIE_SET = Sets.newConcurrentHashSet();
    private int zombieCheckTimes;
    private int scheduledTime;
    private String registerType;
    private boolean checked;
    private final SelectorMapper selectorMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final PluginMapper pluginMapper;
    private final SelectorConditionMapper selectorConditionMapper;

    public UpstreamCheckService(SelectorMapper selectorMapper, ApplicationEventPublisher eventPublisher, PluginMapper pluginMapper, SelectorConditionMapper selectorConditionMapper, ShenyuRegisterCenterConfig shenyuRegisterCenterConfig) {
        this.selectorMapper = selectorMapper;
        this.eventPublisher = eventPublisher;
        this.pluginMapper = pluginMapper;
        this.selectorConditionMapper = selectorConditionMapper;
        Properties props = shenyuRegisterCenterConfig.getProps();
        this.checked = Boolean.parseBoolean(props.getProperty("checked", "true"));
        this.zombieCheckTimes = Integer.parseInt(props.getProperty("zombieCheckTimes", "5"));
        this.scheduledTime = Integer.parseInt(props.getProperty("scheduledTime", "10"));
        this.registerType = shenyuRegisterCenterConfig.getRegisterType();
        if ("http".equalsIgnoreCase(this.registerType)) {
            this.setup();
        }
    }

    public void setup() {
        if (this.checked) {
            this.fetchUpstreamData();
            new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), ShenyuThreadFactory.create((String)"scheduled-upstream-task", (boolean)false)).scheduleWithFixedDelay(this::scheduled, 10L, this.scheduledTime, TimeUnit.SECONDS);
        }
    }

    public static void removeByKey(String selectorName) {
        UPSTREAM_MAP.remove(selectorName);
    }

    public void submit(String selectorName, DivideUpstream divideUpstream) {
        if (!"http".equalsIgnoreCase(this.registerType)) {
            return;
        }
        if (UPSTREAM_MAP.containsKey(selectorName)) {
            List upstreams = UPSTREAM_MAP.getOrDefault(selectorName, Collections.emptyList());
            Optional<DivideUpstream> exists = upstreams.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getUpstreamUrl()) && item.getUpstreamUrl().equals(divideUpstream.getUpstreamUrl())).findFirst();
            if (!exists.isPresent()) {
                upstreams.add(divideUpstream);
            } else {
                log.info("upstream host {} is exists.", (Object)divideUpstream.getUpstreamHost());
            }
        } else {
            UPSTREAM_MAP.put(selectorName, Lists.newArrayList((Object[])new DivideUpstream[]{divideUpstream}));
        }
    }

    public void replace(String selectorName, List<DivideUpstream> divideUpstreams) {
        if (!"http".equalsIgnoreCase(this.registerType)) {
            return;
        }
        UPSTREAM_MAP.put(selectorName, divideUpstreams);
    }

    private void scheduled() {
        try {
            if (ZOMBIE_SET.size() > 0) {
                ZOMBIE_SET.forEach(this::checkZombie);
            }
            if (UPSTREAM_MAP.size() > 0) {
                UPSTREAM_MAP.forEach(this::check);
            }
        }
        catch (Exception e) {
            log.error("upstream scheduled check error -------- ", (Throwable)e);
        }
    }

    private void checkZombie(ZombieUpstream zombieUpstream) {
        ZOMBIE_SET.remove(zombieUpstream);
        String selectorName = zombieUpstream.getSelectorName();
        DivideUpstream divideUpstream = zombieUpstream.getDivideUpstream();
        boolean pass = UpstreamCheckUtils.checkUrl((String)divideUpstream.getUpstreamUrl());
        if (pass) {
            divideUpstream.setTimestamp(System.currentTimeMillis());
            divideUpstream.setStatus(true);
            log.info("UpstreamCacheManager check zombie upstream success the url: {}, host: {} ", (Object)divideUpstream.getUpstreamUrl(), (Object)divideUpstream.getUpstreamHost());
            List old = ListUtils.unmodifiableList(UPSTREAM_MAP.getOrDefault(selectorName, Collections.emptyList()));
            this.submit(selectorName, divideUpstream);
            this.updateHandler(selectorName, old, UPSTREAM_MAP.get(selectorName));
        } else {
            log.error("check zombie upstream the url={} is fail", (Object)divideUpstream.getUpstreamUrl());
            if (zombieUpstream.getZombieCheckTimes() > NumberUtils.INTEGER_ZERO) {
                zombieUpstream.setZombieCheckTimes(zombieUpstream.getZombieCheckTimes() - NumberUtils.INTEGER_ONE);
                ZOMBIE_SET.add(zombieUpstream);
            }
        }
    }

    private void check(String selectorName, List<DivideUpstream> upstreamList) {
        ArrayList successList = Lists.newArrayListWithCapacity((int)upstreamList.size());
        for (DivideUpstream divideUpstream : upstreamList) {
            boolean pass = UpstreamCheckUtils.checkUrl((String)divideUpstream.getUpstreamUrl());
            if (pass) {
                if (!divideUpstream.isStatus()) {
                    divideUpstream.setTimestamp(System.currentTimeMillis());
                    divideUpstream.setStatus(true);
                    log.info("UpstreamCacheManager check success the url: {}, host: {} ", (Object)divideUpstream.getUpstreamUrl(), (Object)divideUpstream.getUpstreamHost());
                }
                successList.add(divideUpstream);
                continue;
            }
            divideUpstream.setStatus(false);
            ZOMBIE_SET.add(ZombieUpstream.transform((DivideUpstream)divideUpstream, (int)this.zombieCheckTimes, (String)selectorName));
            log.error("check the url={} is fail ", (Object)divideUpstream.getUpstreamUrl());
        }
        this.updateHandler(selectorName, upstreamList, successList);
    }

    private void updateHandler(String selectorName, List<DivideUpstream> upstreamList, List<DivideUpstream> successList) {
        if (successList.size() == upstreamList.size()) {
            return;
        }
        if (successList.size() > 0) {
            UPSTREAM_MAP.put(selectorName, successList);
            this.updateSelectorHandler(selectorName, successList);
        } else {
            UPSTREAM_MAP.remove(selectorName);
            this.updateSelectorHandler(selectorName, null);
        }
    }

    private void updateSelectorHandler(String selectorName, List<DivideUpstream> upstreams) {
        SelectorDO selectorDO = this.selectorMapper.selectByName(selectorName);
        if (Objects.nonNull(selectorDO)) {
            List<ConditionData> conditionDataList = ConditionTransfer.INSTANCE.mapToSelectorDOS(this.selectorConditionMapper.selectByQuery(new SelectorConditionQuery(selectorDO.getId())));
            PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
            String handler = CollectionUtils.isEmpty(upstreams) ? "" : GsonUtils.getInstance().toJson(upstreams);
            selectorDO.setHandle(handler);
            this.selectorMapper.updateSelective(selectorDO);
            if (Objects.nonNull(pluginDO)) {
                SelectorData selectorData = SelectorDO.transFrom(selectorDO, pluginDO.getName(), conditionDataList);
                selectorData.setHandle(handler);
                this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.UPDATE, Collections.singletonList(selectorData)));
            }
        }
    }

    public void fetchUpstreamData() {
        List<PluginDO> pluginDOList = this.pluginMapper.selectByNames(PluginEnum.getUpstreamNames());
        if (CollectionUtils.isEmpty(pluginDOList)) {
            return;
        }
        pluginDOList.stream().filter(Objects::nonNull).forEach(pluginDO -> {
            List<SelectorDO> selectorDOList = this.selectorMapper.findByPluginId(pluginDO.getId());
            for (SelectorDO selectorDO : selectorDOList) {
                List divideUpstreams;
                if (Objects.isNull(selectorDO) || !CollectionUtils.isNotEmpty((Collection)(divideUpstreams = GsonUtils.getInstance().fromList(selectorDO.getHandle(), DivideUpstream.class)))) continue;
                UPSTREAM_MAP.put(selectorDO.getName(), divideUpstreams);
            }
        });
    }
}

