/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.RuleConditionDTO;
import org.apache.shenyu.admin.model.dto.RuleDTO;
import org.apache.shenyu.admin.model.dto.SelectorConditionDTO;
import org.apache.shenyu.admin.model.dto.SelectorDTO;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.service.register.ShenyuClientRegisterServiceFactory;
import org.apache.shenyu.common.dto.convert.DivideUpstream;
import org.apache.shenyu.common.dto.convert.rule.RuleHandle;
import org.apache.shenyu.common.dto.convert.rule.RuleHandleFactory;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;

public abstract class AbstractShenyuClientRegisterServiceImpl
implements ShenyuClientRegisterServiceFactory {
    protected abstract void saveOrUpdateMetaData(MetaDataDO var1, MetaDataRegisterDTO var2);

    protected abstract String handlerSelector(MetaDataRegisterDTO var1);

    protected abstract void handlerRule(String var1, MetaDataRegisterDTO var2, MetaDataDO var3);

    @Override
    public String registerURI(String contextPath, List<String> uriList) {
        return null;
    }

    protected SelectorDTO registerSelector(String contextPath, String pluginId) {
        SelectorDTO selectorDTO = this.buildDefaultSelectorDTO(contextPath);
        selectorDTO.setPluginId(pluginId);
        selectorDTO.setSelectorConditions(this.buildDefaultSelectorConditionDTO(contextPath));
        return selectorDTO;
    }

    protected RuleDTO registerRule(String selectorId, String path, String pluginName, String ruleName) {
        RuleHandle ruleHandle = pluginName.equals(PluginEnum.CONTEXT_PATH.getName()) ? RuleHandleFactory.ruleHandle((String)pluginName, (String)this.buildContextPath(path)) : RuleHandleFactory.ruleHandle((String)pluginName, (String)path);
        RuleDTO ruleDTO = RuleDTO.builder().selectorId(selectorId).name(ruleName).matchMode(MatchModeEnum.AND.getCode()).enabled(Boolean.TRUE).loged(Boolean.TRUE).sort(1).handle(ruleHandle.toJson()).build();
        RuleConditionDTO ruleConditionDTO = RuleConditionDTO.builder().paramType(ParamTypeEnum.URI.getName()).paramName("/").paramValue(path).build();
        if (path.indexOf("*") > 1) {
            ruleConditionDTO.setOperator(OperatorEnum.MATCH.getAlias());
        } else {
            ruleConditionDTO.setOperator(OperatorEnum.EQ.getAlias());
        }
        ruleDTO.setRuleConditions(Collections.singletonList(ruleConditionDTO));
        return ruleDTO;
    }

    protected List<SelectorConditionDTO> buildDefaultSelectorConditionDTO(String contextPath) {
        SelectorConditionDTO selectorConditionDTO = new SelectorConditionDTO();
        selectorConditionDTO.setParamType(ParamTypeEnum.URI.getName());
        selectorConditionDTO.setParamName("/");
        selectorConditionDTO.setOperator(OperatorEnum.MATCH.getAlias());
        selectorConditionDTO.setParamValue(contextPath + "/**");
        return Collections.singletonList(selectorConditionDTO);
    }

    protected String buildContextPath(String path) {
        String split = "/";
        String[] splitList = StringUtils.split((String)path, (String)split);
        if (splitList.length != 0) {
            return split.concat(splitList[0]);
        }
        return split;
    }

    protected SelectorDTO buildDefaultSelectorDTO(String name) {
        return SelectorDTO.builder().name(name).type(SelectorTypeEnum.CUSTOM_FLOW.getCode()).matchMode(MatchModeEnum.AND.getCode()).enabled(Boolean.TRUE).loged(Boolean.TRUE).continued(Boolean.TRUE).sort(1).build();
    }

    protected DivideUpstream buildDivideUpstream(String uri) {
        return DivideUpstream.builder().upstreamHost("localhost").protocol("http://").upstreamUrl(uri).weight(50).build();
    }

    protected boolean checkPathExist(MetaDataDO existMetaDataDO, MetaDataRegisterDTO dto) {
        return Objects.nonNull(existMetaDataDO) && (!existMetaDataDO.getMethodName().equals(dto.getMethodName()) || !existMetaDataDO.getServiceName().equals(dto.getServiceName()));
    }
}

