/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.register.AbstractShenyuClientRegisterServiceImpl;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.DivideUpstream;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service(value="default")
public class ShenyuClientRegisterDefaultServiceImpl
extends AbstractShenyuClientRegisterServiceImpl {
    private final ApplicationEventPublisher eventPublisher;
    private final SelectorService selectorService;

    public ShenyuClientRegisterDefaultServiceImpl(ApplicationEventPublisher eventPublisher, SelectorService selectorService) {
        this.eventPublisher = eventPublisher;
        this.selectorService = selectorService;
    }

    @Override
    public String register(MetaDataRegisterDTO metaDataRegisterDTO) {
        return null;
    }

    @Override
    public String registerURI(String contextPath, List<String> uriList) {
        SelectorDO selector = this.selectorService.findByName(contextPath);
        SelectorData selectorData = this.selectorService.buildByName(contextPath);
        String handler = GsonUtils.getInstance().toJson(this.buildDivideUpstreamList(uriList));
        selector.setHandle(handler);
        selectorData.setHandle(handler);
        this.selectorService.updateSelective(selector);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.UPDATE, Collections.singletonList(selectorData)));
        return "success";
    }

    @Override
    protected void saveOrUpdateMetaData(MetaDataDO exist, MetaDataRegisterDTO metaDataDTO) {
    }

    @Override
    protected String handlerSelector(MetaDataRegisterDTO metaDataDTO) {
        return "";
    }

    @Override
    protected void handlerRule(String selectorId, MetaDataRegisterDTO metaDataDTO, MetaDataDO exist) {
    }

    private List<DivideUpstream> buildDivideUpstreamList(List<String> uriList) {
        return uriList.stream().map(this::buildDivideUpstream).collect(Collectors.toList());
    }
}

