/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import java.util.Objects;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.RuleService;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.register.AbstractShenyuClientRegisterServiceImpl;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="grpc")
public class ShenyuClientRegisterGrpcServiceImpl
extends AbstractShenyuClientRegisterServiceImpl {
    private final MetaDataService metaDataService;
    private final SelectorService selectorService;
    private final RuleService ruleService;

    public ShenyuClientRegisterGrpcServiceImpl(MetaDataService metaDataService, SelectorService selectorService, RuleService ruleService) {
        this.metaDataService = metaDataService;
        this.selectorService = selectorService;
        this.ruleService = ruleService;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public synchronized String register(MetaDataRegisterDTO dto) {
        MetaDataDO exist = this.metaDataService.findByPath(dto.getPath());
        this.saveOrUpdateMetaData(exist, dto);
        String selectorId = this.handlerSelector(dto);
        this.handlerRule(selectorId, dto, exist);
        return "success";
    }

    @Override
    public void saveOrUpdateMetaData(MetaDataDO exist, MetaDataRegisterDTO metaDataDTO) {
        this.metaDataService.saveOrUpdateMetaData(exist, metaDataDTO);
    }

    @Override
    public String handlerSelector(MetaDataRegisterDTO dto) {
        return this.selectorService.handlerSelectorNeedUpstreamCheck(dto, PluginEnum.GRPC.getName());
    }

    @Override
    public void handlerRule(String selectorId, MetaDataRegisterDTO metaDataDTO, MetaDataDO exist) {
        this.ruleService.register(this.registerRule(selectorId, metaDataDTO.getPath(), PluginEnum.GRPC.getName(), metaDataDTO.getRuleName()), metaDataDTO.getPath(), Objects.isNull(exist));
    }
}

