/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import java.util.Objects;
import org.apache.shenyu.admin.model.dto.SelectorDTO;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.PluginService;
import org.apache.shenyu.admin.service.RuleService;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.register.AbstractShenyuClientRegisterServiceImpl;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sofa")
public class ShenyuClientRegisterSofaServiceImpl
extends AbstractShenyuClientRegisterServiceImpl {
    private final MetaDataService metaDataService;
    private final SelectorService selectorService;
    private final RuleService ruleService;
    private final PluginService pluginService;

    public ShenyuClientRegisterSofaServiceImpl(MetaDataService metaDataService, SelectorService selectorService, RuleService ruleService, PluginService pluginService) {
        this.metaDataService = metaDataService;
        this.selectorService = selectorService;
        this.ruleService = ruleService;
        this.pluginService = pluginService;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public synchronized String register(MetaDataRegisterDTO dto) {
        MetaDataDO metaDataDO = this.metaDataService.findByPath(dto.getPath());
        if (this.checkPathExist(metaDataDO, dto)) {
            return "you path already exist!";
        }
        MetaDataDO exist = this.metaDataService.findByServiceNameAndMethodName(dto.getServiceName(), dto.getMethodName());
        this.saveOrUpdateMetaData(exist, dto);
        String selectorId = this.handlerSelector(dto);
        this.handlerRule(selectorId, dto, exist);
        return "success";
    }

    @Override
    public void saveOrUpdateMetaData(MetaDataDO exist, MetaDataRegisterDTO metaDataDTO) {
        this.metaDataService.saveOrUpdateMetaData(exist, metaDataDTO);
    }

    @Override
    public String handlerSelector(MetaDataRegisterDTO metaDataDTO) {
        SelectorDO selectorDO = this.selectorService.findByName(metaDataDTO.getContextPath());
        if (Objects.nonNull(selectorDO)) {
            return selectorDO.getId();
        }
        SelectorDTO selectorDTO = this.registerSelector(metaDataDTO.getContextPath(), this.pluginService.selectIdByName(PluginEnum.SOFA.getName()));
        selectorDTO.setHandle(metaDataDTO.getAppName());
        return this.selectorService.register(selectorDTO);
    }

    @Override
    public void handlerRule(String selectorId, MetaDataRegisterDTO metaDataDTO, MetaDataDO exist) {
        this.ruleService.register(this.registerRule(selectorId, metaDataDTO.getPath(), PluginEnum.SOFA.getName(), metaDataDTO.getRuleName()), metaDataDTO.getPath(), Objects.isNull(exist));
    }
}

