/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.RuleMapper;
import org.apache.shenyu.admin.model.dto.SelectorDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.PluginService;
import org.apache.shenyu.admin.service.RuleService;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.register.AbstractShenyuClientRegisterServiceImpl;
import org.apache.shenyu.admin.transfer.MetaDataTransfer;
import org.apache.shenyu.common.dto.convert.selector.SpringCloudSelectorHandle;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="springCloud")
public class ShenyuClientRegisterSpringCloudServiceImpl
extends AbstractShenyuClientRegisterServiceImpl {
    private final ApplicationEventPublisher eventPublisher;
    private final SelectorService selectorService;
    private final RuleService ruleService;
    private final MetaDataService metaDataService;
    private final PluginService pluginService;

    public ShenyuClientRegisterSpringCloudServiceImpl(MetaDataService metaDataService, ApplicationEventPublisher eventPublisher, SelectorService selectorService, RuleService ruleService, RuleMapper ruleMapper, PluginService pluginService) {
        this.metaDataService = metaDataService;
        this.eventPublisher = eventPublisher;
        this.selectorService = selectorService;
        this.ruleService = ruleService;
        this.pluginService = pluginService;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public synchronized String register(MetaDataRegisterDTO dto) {
        MetaDataDO metaDataDO = this.metaDataService.findByPath(dto.getContextPath() + "/**");
        if (Objects.isNull(metaDataDO)) {
            this.saveOrUpdateMetaData(metaDataDO, dto);
        }
        String selectorId = this.handlerSelector(dto);
        this.handlerRule(selectorId, dto, metaDataDO);
        String contextPath = dto.getContextPath();
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            this.registerContextPathPlugin(contextPath);
        }
        return "success";
    }

    @Override
    public void saveOrUpdateMetaData(MetaDataDO exist, MetaDataRegisterDTO dto) {
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        BaseDO metaDataDO = ((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)((BaseDO.BaseDOBuilder)((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)((MetaDataDO.MetaDataDOBuilder)MetaDataDO.builder().appName(dto.getAppName())).path(dto.getContextPath() + "/**")).pathDesc(dto.getAppName() + "spring cloud meta data info")).serviceName(dto.getAppName())).methodName(dto.getContextPath())).rpcType(dto.getRpcType())).enabled(dto.isEnabled())).id(UUIDUtils.getInstance().generateShortUuid())).dateCreated(currentTime)).dateUpdated(currentTime)).build();
        this.metaDataService.insert((MetaDataDO)metaDataDO);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.META_DATA, DataEventTypeEnum.CREATE, Collections.singletonList(MetaDataTransfer.INSTANCE.mapToData((MetaDataDO)metaDataDO))));
    }

    @Override
    public String handlerSelector(MetaDataRegisterDTO dto) {
        SelectorDO selectorDO;
        String contextPath = dto.getContextPath();
        if (StringUtils.isEmpty((CharSequence)contextPath)) {
            contextPath = this.buildContextPath(dto.getPath());
        }
        if (Objects.nonNull(selectorDO = this.selectorService.findByName(contextPath))) {
            return selectorDO.getId();
        }
        SelectorDTO selectorDTO = this.registerSelector(contextPath, this.pluginService.selectIdByName(PluginEnum.SPRING_CLOUD.getName()));
        selectorDTO.setHandle(GsonUtils.getInstance().toJson((Object)this.buildSpringCloudSelectorHandle(dto.getAppName())));
        return this.selectorService.register(selectorDTO);
    }

    @Override
    public void handlerRule(String selectorId, MetaDataRegisterDTO dto, MetaDataDO exist) {
        this.ruleService.register(this.registerRule(selectorId, dto.getPath(), PluginEnum.SPRING_CLOUD.getName(), dto.getRuleName()), dto.getRuleName(), false);
    }

    private void registerContextPathPlugin(String contextPath) {
        String name = "/context-path" + contextPath;
        SelectorDO selectorDO = this.selectorService.findByName(name);
        if (Objects.isNull(selectorDO)) {
            String contextPathSelectorId = this.registerContextPathSelector(contextPath, name);
            this.ruleService.register(this.registerRule(contextPathSelectorId, contextPath + "/**", PluginEnum.CONTEXT_PATH.getName(), name), name, false);
        }
    }

    private String registerContextPathSelector(String contextPath, String name) {
        SelectorDTO selectorDTO = this.buildDefaultSelectorDTO(name);
        selectorDTO.setPluginId(this.pluginService.selectIdByName(PluginEnum.CONTEXT_PATH.getName()));
        selectorDTO.setSelectorConditions(this.buildDefaultSelectorConditionDTO(contextPath));
        return this.selectorService.register(selectorDTO);
    }

    private SpringCloudSelectorHandle buildSpringCloudSelectorHandle(String serviceId) {
        return SpringCloudSelectorHandle.builder().serviceId(serviceId).build();
    }
}

