/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.spring;

import com.google.common.base.Splitter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.shenyu.admin.config.properties.DataBaseProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class LocalDataSourceLoader
implements InstantiationAwareBeanPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalDataSourceLoader.class);
    private static final String PRE_FIX = "file:";
    @Resource
    private DataBaseProperties dataBaseProperties;

    public Object postProcessAfterInitialization(@NonNull Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSourceProperties && this.dataBaseProperties.getInitEnable().booleanValue()) {
            this.init((DataSourceProperties)bean);
        }
        return bean;
    }

    protected void init(DataSourceProperties properties) {
        String jdbcUrl = StringUtils.replace((String)properties.getUrl(), (String)"/shenyu?", (String)"?");
        Connection connection = DriverManager.getConnection(jdbcUrl, properties.getUsername(), properties.getPassword());
        this.execute(connection);
    }

    private void execute(Connection conn) throws Exception {
        ScriptRunner runner = new ScriptRunner(conn);
        runner.setLogWriter(null);
        Resources.setCharset((Charset)StandardCharsets.UTF_8);
        String initScript = this.dataBaseProperties.getInitScript();
        List initScripts = Splitter.on((String)";").splitToList((CharSequence)initScript);
        for (String sqlScript : initScripts) {
            if (sqlScript.startsWith(PRE_FIX)) {
                String sqlFile = sqlScript.substring(PRE_FIX.length());
                Reader fileReader = LocalDataSourceLoader.getResourceAsReader(sqlFile);
                log.info("execute shenyu schema sql: {}", (Object)sqlFile);
                runner.runScript(fileReader);
                continue;
            }
            Reader fileReader = Resources.getResourceAsReader((String)sqlScript);
            log.info("execute shenyu schema sql: {}", (Object)sqlScript);
            runner.runScript(fileReader);
        }
        runner.closeConnection();
        conn.close();
    }

    private static Reader getResourceAsReader(String resource) throws IOException {
        return new InputStreamReader((InputStream)new FileInputStream(resource), StandardCharsets.UTF_8);
    }
}

