/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.transfer;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.shenyu.admin.model.dto.AppAuthDTO;
import org.apache.shenyu.admin.model.entity.AppAuthDO;
import org.apache.shenyu.admin.model.vo.AppAuthVO;
import org.apache.shenyu.admin.transfer.AppAuthTransfer;

public class AppAuthTransferImpl
implements AppAuthTransfer {
    private final DatatypeFactory datatypeFactory;

    public AppAuthTransferImpl() {
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public AppAuthDO mapToEntity(AppAuthDTO appAuthDTO) {
        if (appAuthDTO == null) {
            return null;
        }
        AppAuthDO.AppAuthDOBuilder<?, ?> appAuthDO = AppAuthDO.builder();
        appAuthDO.id(appAuthDTO.getId());
        appAuthDO.appKey(appAuthDTO.getAppKey());
        appAuthDO.appSecret(appAuthDTO.getAppSecret());
        appAuthDO.enabled(appAuthDTO.getEnabled());
        appAuthDO.open(appAuthDTO.getOpen());
        appAuthDO.userId(appAuthDTO.getUserId());
        appAuthDO.phone(appAuthDTO.getPhone());
        appAuthDO.extInfo(appAuthDTO.getExtInfo());
        return appAuthDO.build();
    }

    @Override
    public AppAuthVO mapToVO(AppAuthDO appAuthDO) {
        if (appAuthDO == null) {
            return null;
        }
        AppAuthVO appAuthVO = new AppAuthVO();
        appAuthVO.setId(appAuthDO.getId());
        appAuthVO.setAppKey(appAuthDO.getAppKey());
        appAuthVO.setAppSecret(appAuthDO.getAppSecret());
        appAuthVO.setUserId(appAuthDO.getUserId());
        appAuthVO.setPhone(appAuthDO.getPhone());
        appAuthVO.setExtInfo(appAuthDO.getExtInfo());
        appAuthVO.setOpen(appAuthDO.getOpen());
        appAuthVO.setEnabled(appAuthDO.getEnabled());
        appAuthVO.setDateUpdated(this.xmlGregorianCalendarToString(this.dateToXmlGregorianCalendar(appAuthDO.getDateUpdated()), null));
        return appAuthVO;
    }

    private String xmlGregorianCalendarToString(XMLGregorianCalendar xcal, String dateFormat) {
        if (xcal == null) {
            return null;
        }
        if (dateFormat == null) {
            return xcal.toString();
        }
        Date d = xcal.toGregorianCalendar().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(d);
    }

    private XMLGregorianCalendar dateToXmlGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        return this.datatypeFactory.newXMLGregorianCalendar(c);
    }
}

