/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.transfer;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.shenyu.admin.model.dto.MetaDataDTO;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.vo.MetaDataVO;
import org.apache.shenyu.admin.transfer.MetaDataTransfer;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;

public class MetaDataTransferImpl
implements MetaDataTransfer {
    private final DatatypeFactory datatypeFactory;

    public MetaDataTransferImpl() {
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public MetaDataDO mapToEntity(MetaDataDTO metaDataDTO) {
        if (metaDataDTO == null) {
            return null;
        }
        MetaDataDO.MetaDataDOBuilder<?, ?> metaDataDO = MetaDataDO.builder();
        metaDataDO.id(metaDataDTO.getId());
        metaDataDO.appName(metaDataDTO.getAppName());
        metaDataDO.path(metaDataDTO.getPath());
        metaDataDO.pathDesc(metaDataDTO.getPathDesc());
        metaDataDO.rpcType(metaDataDTO.getRpcType());
        metaDataDO.serviceName(metaDataDTO.getServiceName());
        metaDataDO.methodName(metaDataDTO.getMethodName());
        metaDataDO.parameterTypes(metaDataDTO.getParameterTypes());
        metaDataDO.rpcExt(metaDataDTO.getRpcExt());
        metaDataDO.enabled(metaDataDTO.getEnabled());
        return metaDataDO.build();
    }

    @Override
    public MetaDataDO mapRegisterDTOToEntity(MetaDataRegisterDTO metaDataDTO) {
        if (metaDataDTO == null) {
            return null;
        }
        MetaDataDO.MetaDataDOBuilder<?, ?> metaDataDO = MetaDataDO.builder();
        metaDataDO.appName(metaDataDTO.getAppName());
        metaDataDO.path(metaDataDTO.getPath());
        metaDataDO.pathDesc(metaDataDTO.getPathDesc());
        metaDataDO.rpcType(metaDataDTO.getRpcType());
        metaDataDO.serviceName(metaDataDTO.getServiceName());
        metaDataDO.methodName(metaDataDTO.getMethodName());
        metaDataDO.parameterTypes(metaDataDTO.getParameterTypes());
        metaDataDO.rpcExt(metaDataDTO.getRpcExt());
        metaDataDO.enabled(metaDataDTO.isEnabled());
        return metaDataDO.build();
    }

    @Override
    public MetaData mapToData(MetaDataDTO metaDataDTO) {
        if (metaDataDTO == null) {
            return null;
        }
        MetaData.MetaDataBuilder metaData = MetaData.builder();
        metaData.id(metaDataDTO.getId());
        metaData.appName(metaDataDTO.getAppName());
        metaData.contextPath(metaDataDTO.getContextPath());
        metaData.path(metaDataDTO.getPath());
        metaData.rpcType(metaDataDTO.getRpcType());
        metaData.serviceName(metaDataDTO.getServiceName());
        metaData.methodName(metaDataDTO.getMethodName());
        metaData.parameterTypes(metaDataDTO.getParameterTypes());
        metaData.rpcExt(metaDataDTO.getRpcExt());
        metaData.enabled(metaDataDTO.getEnabled());
        return metaData.build();
    }

    @Override
    public MetaData mapToData(MetaDataDO metaDataDO) {
        if (metaDataDO == null) {
            return null;
        }
        MetaData.MetaDataBuilder metaData = MetaData.builder();
        metaData.id(metaDataDO.getId());
        metaData.appName(metaDataDO.getAppName());
        metaData.path(metaDataDO.getPath());
        metaData.rpcType(metaDataDO.getRpcType());
        metaData.serviceName(metaDataDO.getServiceName());
        metaData.methodName(metaDataDO.getMethodName());
        metaData.parameterTypes(metaDataDO.getParameterTypes());
        metaData.rpcExt(metaDataDO.getRpcExt());
        metaData.enabled(metaDataDO.getEnabled());
        return metaData.build();
    }

    @Override
    public List<MetaData> mapToDataAll(List<MetaDataDO> metaDataDOList) {
        if (metaDataDOList == null) {
            return null;
        }
        ArrayList<MetaData> list = new ArrayList<MetaData>(metaDataDOList.size());
        for (MetaDataDO metaDataDO : metaDataDOList) {
            list.add(this.mapToData(metaDataDO));
        }
        return list;
    }

    @Override
    public MetaDataVO mapToVO(MetaDataDO metaDataDO) {
        if (metaDataDO == null) {
            return null;
        }
        MetaDataVO metaDataVO = new MetaDataVO();
        metaDataVO.setAppName(metaDataDO.getAppName());
        metaDataVO.setPath(metaDataDO.getPath());
        metaDataVO.setPathDesc(metaDataDO.getPathDesc());
        metaDataVO.setRpcType(metaDataDO.getRpcType());
        metaDataVO.setServiceName(metaDataDO.getServiceName());
        metaDataVO.setMethodName(metaDataDO.getMethodName());
        metaDataVO.setParameterTypes(metaDataDO.getParameterTypes());
        metaDataVO.setRpcExt(metaDataDO.getRpcExt());
        metaDataVO.setId(metaDataDO.getId());
        metaDataVO.setDateCreated(this.xmlGregorianCalendarToString(this.dateToXmlGregorianCalendar(metaDataDO.getDateCreated()), null));
        metaDataVO.setDateUpdated(this.xmlGregorianCalendarToString(this.dateToXmlGregorianCalendar(metaDataDO.getDateUpdated()), null));
        metaDataVO.setEnabled(metaDataDO.getEnabled());
        return metaDataVO;
    }

    @Override
    public List<MetaDataVO> mapToVOList(List<MetaDataDO> metaDataDOList) {
        if (metaDataDOList == null) {
            return null;
        }
        ArrayList<MetaDataVO> list = new ArrayList<MetaDataVO>(metaDataDOList.size());
        for (MetaDataDO metaDataDO : metaDataDOList) {
            list.add(this.mapToVO(metaDataDO));
        }
        return list;
    }

    private String xmlGregorianCalendarToString(XMLGregorianCalendar xcal, String dateFormat) {
        if (xcal == null) {
            return null;
        }
        if (dateFormat == null) {
            return xcal.toString();
        }
        Date d = xcal.toGregorianCalendar().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(d);
    }

    private XMLGregorianCalendar dateToXmlGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        return this.datatypeFactory.newXMLGregorianCalendar(c);
    }
}

