/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Optional;
import lombok.Generated;
import org.apache.shenyu.admin.config.properties.JwtProperties;
import org.apache.shenyu.admin.model.custom.UserInfo;
import org.apache.shenyu.admin.spring.SpringBeanUtils;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JwtUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtUtils.class);

    public static UserInfo getUserInfo() {
        return (UserInfo)SecurityUtils.getSubject().getPrincipal();
    }

    public static String getIssuer(String token) {
        DecodedJWT jwt = JWT.decode((String)token);
        return Optional.ofNullable(jwt).map(item -> item.getClaim("userName").asString()).orElse("");
    }

    public static LocalDate getIssuerDate(String token) {
        DecodedJWT jwt = JwtUtils.verifierToken(token);
        if (jwt == null) {
            return null;
        }
        Date date = jwt.getIssuedAt();
        return Optional.ofNullable(date).map(it -> it.toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).orElse(null);
    }

    public static String generateToken(String userName) {
        try {
            return JWT.create().withClaim("userName", userName).withExpiresAt(new Date()).sign(JwtUtils.generateAlgorithm());
        }
        catch (JWTCreationException | IllegalArgumentException e) {
            log.error("JWTToken generate fail ", e);
            return "";
        }
    }

    private static DecodedJWT verifierToken(String token) {
        DecodedJWT jwt = null;
        try {
            JWTVerifier verifier = JWT.require((Algorithm)JwtUtils.generateAlgorithm()).build();
            jwt = verifier.verify(token);
        }
        catch (JWTVerificationException e) {
            log.info("jwt decode fail, token: {} ", (Object)token, (Object)e);
        }
        return jwt;
    }

    private static Algorithm generateAlgorithm() {
        JwtProperties properties = SpringBeanUtils.getInstance().getBean(JwtProperties.class);
        return Algorithm.HMAC256((String)properties.getKey());
    }

    @Generated
    private JwtUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof JwtUtils;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "JwtUtils()";
    }
}

