/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.config.properties.NacosProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={NacosProperties.class})
public class NacosConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ConfigService.class})
    public ConfigService nacosConfigService(NacosProperties nacosProp) throws Exception {
        Properties properties = new Properties();
        if (nacosProp.getAcm() != null && nacosProp.getAcm().isEnabled()) {
            properties.put("endpoint", nacosProp.getAcm().getEndpoint());
            properties.put("namespace", nacosProp.getAcm().getNamespace());
            properties.put("accessKey", nacosProp.getAcm().getAccessKey());
            properties.put("secretKey", nacosProp.getAcm().getSecretKey());
        } else {
            properties.put("serverAddr", nacosProp.getUrl());
            if (StringUtils.isNotBlank((CharSequence)nacosProp.getNamespace())) {
                properties.put("namespace", nacosProp.getNamespace());
            }
            if (StringUtils.isNotBlank((CharSequence)nacosProp.getUsername())) {
                properties.put("username", nacosProp.getUsername());
            }
            if (StringUtils.isNotBlank((CharSequence)nacosProp.getPassword())) {
                properties.put("password", nacosProp.getPassword());
            }
        }
        return NacosFactory.createConfigService((Properties)properties);
    }
}

