/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.disruptor.RegisterServerDisruptorPublisher;
import org.apache.shenyu.admin.service.register.ShenyuClientRegisterService;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.server.api.ShenyuServerRegisterPublisher;
import org.apache.shenyu.register.server.api.ShenyuServerRegisterRepository;
import org.apache.shenyu.spi.ExtensionLoader;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RegisterCenterConfiguration {
    @Bean
    @ConfigurationProperties(prefix="shenyu.register")
    public ShenyuRegisterCenterConfig shenyuRegisterCenterConfig() {
        return new ShenyuRegisterCenterConfig();
    }

    @Bean
    public ShenyuServerRegisterRepository shenyuServerRegisterRepository(ShenyuRegisterCenterConfig shenyuRegisterCenterConfig, List<ShenyuClientRegisterService> shenyuClientRegisterService) {
        String registerType = shenyuRegisterCenterConfig.getRegisterType();
        ShenyuServerRegisterRepository registerRepository = (ShenyuServerRegisterRepository)ExtensionLoader.getExtensionLoader(ShenyuServerRegisterRepository.class).getJoin(registerType);
        RegisterServerDisruptorPublisher publisher = RegisterServerDisruptorPublisher.getInstance();
        Map<String, ShenyuClientRegisterService> registerServiceMap = shenyuClientRegisterService.stream().collect(Collectors.toMap(ShenyuClientRegisterService::rpcType, e -> e));
        publisher.start(registerServiceMap);
        registerRepository.init((ShenyuServerRegisterPublisher)publisher, shenyuRegisterCenterConfig);
        return registerRepository;
    }
}

