/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.disruptor;

import java.util.Map;
import org.apache.shenyu.admin.disruptor.executor.RegisterServerConsumerExecutor;
import org.apache.shenyu.admin.disruptor.subscriber.MetadataExecutorSubscriber;
import org.apache.shenyu.admin.disruptor.subscriber.URIRegisterExecutorSubscriber;
import org.apache.shenyu.admin.service.register.ShenyuClientRegisterService;
import org.apache.shenyu.disruptor.DisruptorProviderManage;
import org.apache.shenyu.disruptor.consumer.QueueConsumerFactory;
import org.apache.shenyu.disruptor.provider.DisruptorProvider;
import org.apache.shenyu.register.common.subsriber.ExecutorSubscriber;
import org.apache.shenyu.register.server.api.ShenyuServerRegisterPublisher;

public class RegisterServerDisruptorPublisher
implements ShenyuServerRegisterPublisher {
    private static final RegisterServerDisruptorPublisher INSTANCE = new RegisterServerDisruptorPublisher();
    private DisruptorProviderManage providerManage;
    private RegisterServerConsumerExecutor.RegisterServerExecutorFactory factory;

    public static RegisterServerDisruptorPublisher getInstance() {
        return INSTANCE;
    }

    public void start(Map<String, ShenyuClientRegisterService> shenyuClientRegisterService) {
        this.factory = new RegisterServerConsumerExecutor.RegisterServerExecutorFactory();
        this.factory.addSubscribers((ExecutorSubscriber)new URIRegisterExecutorSubscriber(shenyuClientRegisterService));
        this.factory.addSubscribers((ExecutorSubscriber)new MetadataExecutorSubscriber(shenyuClientRegisterService));
        this.providerManage = new DisruptorProviderManage((QueueConsumerFactory)this.factory);
        this.providerManage.startup();
    }

    public <T> void publish(T data) {
        DisruptorProvider provider = this.providerManage.getProvider();
        provider.onData(f -> f.setData(data));
    }

    public void close() {
        this.providerManage.getProvider().shutdown();
    }
}

