/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.vo;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import org.apache.shenyu.admin.model.entity.ResourceDO;
import org.apache.shenyu.common.utils.DateUtils;

public class ResourceVO
implements Serializable {
    private static final long serialVersionUID = -3205569090998147615L;
    private String id;
    private String parentId;
    private String title;
    private String name;
    private String url;
    private String component;
    private Integer resourceType;
    private Integer sort;
    private String icon;
    private Boolean isLeaf;
    private Integer isRoute;
    private String perms;
    private Integer status;
    private String dateCreated;
    private String dateUpdated;

    public ResourceVO() {
    }

    public ResourceVO(String id, String parentId, String title, String name, String url, String component, Integer resourceType, Integer sort, String icon, Boolean isLeaf, Integer isRoute, String perms, Integer status, String dateCreated, String dateUpdated) {
        this.id = id;
        this.parentId = parentId;
        this.title = title;
        this.name = name;
        this.url = url;
        this.component = component;
        this.resourceType = resourceType;
        this.sort = sort;
        this.icon = icon;
        this.isLeaf = isLeaf;
        this.isRoute = isRoute;
        this.perms = perms;
        this.status = status;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public Integer getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Boolean getIsLeaf() {
        return this.isLeaf;
    }

    public void setIsLeaf(Boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public Integer getIsRoute() {
        return this.isRoute;
    }

    public void setIsRoute(Integer isRoute) {
        this.isRoute = isRoute;
    }

    public String getPerms() {
        return this.perms;
    }

    public void setPerms(String perms) {
        this.perms = perms;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(String dateCreated) {
        this.dateCreated = dateCreated;
    }

    public String getDateUpdated() {
        return this.dateUpdated;
    }

    public void setDateUpdated(String dateUpdated) {
        this.dateUpdated = dateUpdated;
    }

    public static ResourceVO buildResourceVO(ResourceDO resourceDO) {
        return Optional.ofNullable(resourceDO).map(item -> new ResourceVO(item.getId(), item.getParentId(), item.getTitle(), item.getName(), item.getUrl(), item.getComponent(), item.getResourceType(), item.getSort(), item.getIcon(), item.getIsLeaf(), item.getIsRoute(), item.getPerms(), item.getStatus(), DateUtils.localDateTimeToString((LocalDateTime)item.getDateCreated().toLocalDateTime()), DateUtils.localDateTimeToString((LocalDateTime)item.getDateUpdated().toLocalDateTime()))).orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceVO)) {
            return false;
        }
        ResourceVO that = (ResourceVO)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.parentId, that.parentId) && Objects.equals(this.title, that.title) && Objects.equals(this.name, that.name) && Objects.equals(this.url, that.url) && Objects.equals(this.component, that.component) && Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.sort, that.sort) && Objects.equals(this.icon, that.icon) && Objects.equals(this.isLeaf, that.isLeaf) && Objects.equals(this.isRoute, that.isRoute) && Objects.equals(this.perms, that.perms) && Objects.equals(this.status, that.status) && Objects.equals(this.dateCreated, that.dateCreated) && Objects.equals(this.dateUpdated, that.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.parentId, this.title, this.name, this.url, this.component, this.resourceType, this.sort, this.icon, this.isLeaf, this.isRoute, this.perms, this.status, this.dateCreated, this.dateUpdated);
    }

    public String toString() {
        return "ResourceVO{id='" + this.id + '\'' + ", parentId='" + this.parentId + '\'' + ", title='" + this.title + '\'' + ", name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", component='" + this.component + '\'' + ", resourceType=" + this.resourceType + ", sort=" + this.sort + ", icon='" + this.icon + '\'' + ", isLeaf=" + this.isLeaf + ", isRoute=" + this.isRoute + ", perms='" + this.perms + '\'' + ", status=" + this.status + ", dateCreated='" + this.dateCreated + '\'' + ", dateUpdated='" + this.dateUpdated + '\'' + '}';
    }
}

