/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.mybatis.pg.interceptor;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.shenyu.common.utils.ReflectUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class PostgreSqlQueryInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        CacheKey cacheKey;
        BoundSql boundSql;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        Executor executor = (Executor)invocation.getTarget();
        if (args.length == 4) {
            boundSql = this.getProcessedBoundSql(ms, ms.getBoundSql(parameter));
            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
        } else {
            cacheKey = (CacheKey)args[4];
            boundSql = this.getProcessedBoundSql(ms, (BoundSql)args[5]);
        }
        return executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
    }

    private BoundSql getProcessedBoundSql(MappedStatement ms, BoundSql boundSql) {
        List parameterMappings = boundSql.getParameterMappings();
        Configuration configuration = ms.getConfiguration();
        Object parameterObject = boundSql.getParameterObject();
        String script = boundSql.getSql().replace("`", "\"").toLowerCase();
        BoundSql result = new BoundSql(configuration, script, parameterMappings, parameterObject);
        this.copyParam(boundSql, result);
        return result;
    }

    private void copyParam(BoundSql oldSql, BoundSql newSql) {
        if (ReflectUtils.getFieldValue((Object)oldSql, (String)"metaParameters") != null) {
            MetaObject mo = (MetaObject)ReflectUtils.getFieldValue((Object)oldSql, (String)"metaParameters");
            ReflectUtils.setFieldValue((Object)newSql, (String)"metaParameters", (Object)mo);
        }
        if (ReflectUtils.getFieldValue((Object)oldSql, (String)"additionalParameters") != null) {
            Map map = (Map)ReflectUtils.getFieldValue((Object)oldSql, (String)"additionalParameters");
            ReflectUtils.setFieldValue((Object)newSql, (String)"additionalParameters", (Object)map);
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

