/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.converter;

import java.util.List;
import org.apache.shenyu.admin.service.converter.AbstractSelectorHandleConverter;
import org.apache.shenyu.admin.service.converter.SelectorHandleConverter;
import org.apache.shenyu.admin.utils.CommonUpstreamUtils;
import org.apache.shenyu.common.dto.convert.selector.CommonUpstream;
import org.apache.shenyu.common.dto.convert.selector.SpringCloudSelectorHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.springframework.stereotype.Component;

@Component
public class SpringCloudSelectorHandleConverter
extends AbstractSelectorHandleConverter
implements SelectorHandleConverter {
    @Override
    public List<CommonUpstream> convertUpstream(String handle) {
        return CommonUpstreamUtils.convertCommonUpstreamList(this.convert(handle).getDivideUpstreams());
    }

    @Override
    public String pluginName() {
        return PluginEnum.SPRING_CLOUD.getName();
    }

    @Override
    protected Object doHandle(String handle, List<CommonUpstream> aliveList) {
        SpringCloudSelectorHandle selectorHandle = this.convert(handle);
        List existList = selectorHandle.getDivideUpstreams();
        existList.removeIf(e -> aliveList.stream().noneMatch(alive -> alive.getUpstreamUrl().equals(e.getUpstreamUrl())));
        selectorHandle.setDivideUpstreams(existList);
        return selectorHandle;
    }

    private SpringCloudSelectorHandle convert(String handle) {
        return (SpringCloudSelectorHandle)GsonUtils.getInstance().fromJson(handle, SpringCloudSelectorHandle.class);
    }
}

