/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.AppAuthMapper;
import org.apache.shenyu.admin.mapper.AuthParamMapper;
import org.apache.shenyu.admin.mapper.AuthPathMapper;
import org.apache.shenyu.admin.model.dto.AppAuthDTO;
import org.apache.shenyu.admin.model.dto.AuthApplyDTO;
import org.apache.shenyu.admin.model.dto.AuthParamDTO;
import org.apache.shenyu.admin.model.dto.AuthPathDTO;
import org.apache.shenyu.admin.model.dto.AuthPathWarpDTO;
import org.apache.shenyu.admin.model.entity.AppAuthDO;
import org.apache.shenyu.admin.model.entity.AuthParamDO;
import org.apache.shenyu.admin.model.entity.AuthPathDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.AppAuthQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.AppAuthVO;
import org.apache.shenyu.admin.model.vo.AuthParamVO;
import org.apache.shenyu.admin.model.vo.AuthPathVO;
import org.apache.shenyu.admin.service.AppAuthService;
import org.apache.shenyu.admin.transfer.AppAuthTransfer;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.AuthParamData;
import org.apache.shenyu.common.dto.AuthPathData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.SignUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppAuthServiceImpl
implements AppAuthService {
    private final AppAuthMapper appAuthMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final AuthParamMapper authParamMapper;
    private final AuthPathMapper authPathMapper;

    public AppAuthServiceImpl(AppAuthMapper appAuthMapper, ApplicationEventPublisher eventPublisher, AuthParamMapper authParamMapper, AuthPathMapper authPathMapper) {
        this.appAuthMapper = appAuthMapper;
        this.eventPublisher = eventPublisher;
        this.authParamMapper = authParamMapper;
        this.authPathMapper = authPathMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ShenyuAdminResult applyCreate(AuthApplyDTO authApplyDTO) {
        if (StringUtils.isBlank((CharSequence)authApplyDTO.getAppName()) || authApplyDTO.getOpen().booleanValue() && CollectionUtils.isEmpty(authApplyDTO.getPathList())) {
            return ShenyuAdminResult.error("parameter error");
        }
        AppAuthDO appAuthDO = AppAuthDO.create(authApplyDTO);
        this.appAuthMapper.insert(appAuthDO);
        AuthParamDO authParamDO = AuthParamDO.create(appAuthDO.getId(), authApplyDTO.getAppName(), authApplyDTO.getAppParam());
        this.authParamMapper.save(authParamDO);
        AppAuthData data = AppAuthData.builder().appKey(appAuthDO.getAppKey()).appSecret(appAuthDO.getAppSecret()).open(appAuthDO.getOpen()).enabled(appAuthDO.getEnabled()).paramDataList((List)Lists.newArrayList((Object[])new AuthParamData[]{new AuthParamData(authParamDO.getAppName(), authParamDO.getAppParam())})).build();
        if (appAuthDO.getOpen().booleanValue()) {
            List<AuthPathDO> collect = authApplyDTO.getPathList().stream().map(path -> AuthPathDO.create(path, appAuthDO.getId(), authApplyDTO.getAppName())).collect(Collectors.toList());
            this.authPathMapper.batchSave(collect);
            data.setPathDataList(collect.stream().map(authPathDO -> AuthPathData.builder().appName(authPathDO.getAppName()).path(authPathDO.getPath()).enabled(authPathDO.getEnabled()).build()).collect(Collectors.toList()));
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.APP_AUTH, DataEventTypeEnum.CREATE, Collections.singletonList(data)));
        return ShenyuAdminResult.success("create success");
    }

    @Override
    public ShenyuAdminResult applyUpdate(AuthApplyDTO authApplyDTO) {
        if (StringUtils.isBlank((CharSequence)authApplyDTO.getAppKey()) || StringUtils.isBlank((CharSequence)authApplyDTO.getAppName()) || authApplyDTO.getOpen().booleanValue() && CollectionUtils.isEmpty(authApplyDTO.getPathList())) {
            return ShenyuAdminResult.error("parameter error");
        }
        AppAuthDO appAuthDO = this.appAuthMapper.findByAppKey(authApplyDTO.getAppKey());
        if (Objects.isNull(appAuthDO)) {
            return ShenyuAdminResult.error("the appKey passed in does not exist");
        }
        AuthParamDO authParamDO = this.authParamMapper.findByAuthIdAndAppName(appAuthDO.getId(), authApplyDTO.getAppName());
        if (Objects.isNull(authParamDO)) {
            this.authParamMapper.save(AuthParamDO.create(appAuthDO.getId(), authApplyDTO.getAppName(), authApplyDTO.getAppParam()));
        }
        if (appAuthDO.getOpen().booleanValue()) {
            List<AuthPathDO> existList = this.authPathMapper.findByAuthIdAndAppName(appAuthDO.getId(), authApplyDTO.getAppName());
            if (CollectionUtils.isNotEmpty(existList)) {
                this.authPathMapper.deleteByAuthIdAndAppName(appAuthDO.getId(), authApplyDTO.getAppName());
            }
            List<AuthPathDO> collect = authApplyDTO.getPathList().stream().map(path -> AuthPathDO.create(path, appAuthDO.getId(), authApplyDTO.getAppName())).collect(Collectors.toList());
            this.authPathMapper.batchSave(collect);
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.APP_AUTH, DataEventTypeEnum.CREATE, Collections.singletonList(this.buildByEntity(appAuthDO))));
        return ShenyuAdminResult.success("update success");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ShenyuAdminResult updateDetail(AppAuthDTO appAuthDTO) {
        List<AuthPathDTO> authPathDTOList;
        if (StringUtils.isBlank((CharSequence)appAuthDTO.getAppKey()) || StringUtils.isBlank((CharSequence)appAuthDTO.getAppSecret()) || StringUtils.isBlank((CharSequence)appAuthDTO.getId())) {
            return ShenyuAdminResult.error("parameter error");
        }
        AppAuthDO appAuthDO = AppAuthTransfer.INSTANCE.mapToEntity(appAuthDTO);
        this.appAuthMapper.update(appAuthDO);
        List<AuthParamDTO> authParamDTOList = appAuthDTO.getAuthParamDTOList();
        if (CollectionUtils.isNotEmpty(authParamDTOList)) {
            this.authParamMapper.deleteByAuthId(appAuthDTO.getId());
            List<AuthParamDO> authParamDOList = authParamDTOList.stream().map(dto -> AuthParamDO.create(appAuthDTO.getId(), dto.getAppName(), dto.getAppParam())).collect(Collectors.toList());
            this.authParamMapper.batchSave(authParamDOList);
        }
        if (CollectionUtils.isNotEmpty(authPathDTOList = appAuthDTO.getAuthPathDTOList())) {
            List<AuthPathDO> oldAuthPathDOList = this.authPathMapper.findByAuthId(appAuthDTO.getId());
            String appName = oldAuthPathDOList.stream().findFirst().map(AuthPathDO::getAppName).orElse("");
            this.authPathMapper.deleteByAuthId(appAuthDTO.getId());
            List<AuthPathDO> authPathDOList = authPathDTOList.stream().map(dto -> AuthPathDO.create(dto.getPath(), appAuthDTO.getId(), appName)).collect(Collectors.toList());
            this.authPathMapper.batchSave(authPathDOList);
        }
        AppAuthData appAuthData = this.buildByEntity(appAuthDO);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.APP_AUTH, DataEventTypeEnum.UPDATE, Lists.newArrayList((Object[])new AppAuthData[]{appAuthData})));
        return ShenyuAdminResult.success();
    }

    @Override
    public ShenyuAdminResult updateDetailPath(AuthPathWarpDTO authPathWarpDTO) {
        AppAuthDO appAuthDO = this.appAuthMapper.selectById(authPathWarpDTO.getId());
        if (Objects.isNull(appAuthDO)) {
            return ShenyuAdminResult.error("ID NOT EXIST!");
        }
        List<AuthPathDTO> authPathDTOList = authPathWarpDTO.getAuthPathDTOList();
        if (CollectionUtils.isNotEmpty(authPathDTOList)) {
            this.authPathMapper.deleteByAuthId(authPathWarpDTO.getId());
            List<AuthPathDO> collect = authPathDTOList.stream().map(authPathDTO -> AuthPathDO.create(authPathDTO.getPath(), appAuthDO.getId(), authPathDTO.getAppName())).collect(Collectors.toList());
            this.authPathMapper.batchSave(collect);
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.APP_AUTH, DataEventTypeEnum.UPDATE, Lists.newArrayList((Object[])new AppAuthData[]{this.buildByEntity(appAuthDO)})));
        return ShenyuAdminResult.success();
    }

    @Override
    public ShenyuAdminResult syncData() {
        List<AppAuthDO> appAuthDOList = this.appAuthMapper.selectAll();
        if (CollectionUtils.isNotEmpty(appAuthDOList)) {
            List dataList = appAuthDOList.stream().map(this::buildByEntity).collect(Collectors.toList());
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.APP_AUTH, DataEventTypeEnum.REFRESH, dataList));
        }
        return ShenyuAdminResult.success();
    }

    @Override
    public int createOrUpdate(AppAuthDTO appAuthDTO) {
        DataEventTypeEnum eventType;
        int appAuthCount;
        AppAuthDO appAuthDO = AppAuthDO.create(appAuthDTO);
        if (StringUtils.isEmpty((CharSequence)appAuthDTO.getId())) {
            appAuthDO.setAppSecret(SignUtils.getInstance().generateKey());
            appAuthCount = this.appAuthMapper.insertSelective(appAuthDO);
            eventType = DataEventTypeEnum.CREATE;
        } else {
            appAuthCount = this.appAuthMapper.updateSelective(appAuthDO);
            eventType = DataEventTypeEnum.UPDATE;
        }
        AppAuthData data = AppAuthData.builder().appKey(appAuthDO.getAppKey()).appSecret(appAuthDO.getAppSecret()).open(appAuthDO.getOpen()).enabled(appAuthDO.getEnabled()).paramDataList(null).pathDataList(null).build();
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.APP_AUTH, eventType, Collections.singletonList(data)));
        return appAuthCount;
    }

    @Override
    public int delete(List<String> ids) {
        int appAuthCount = 0;
        for (String id : ids) {
            AppAuthDO appAuthDO = this.appAuthMapper.selectById(id);
            appAuthCount += this.appAuthMapper.delete(id);
            this.authParamMapper.deleteByAuthId(id);
            this.authPathMapper.deleteByAuthId(id);
            AppAuthData data = AppAuthData.builder().appKey(appAuthDO.getAppKey()).appSecret(appAuthDO.getAppSecret()).open(appAuthDO.getOpen()).enabled(appAuthDO.getEnabled()).paramDataList(null).pathDataList(null).build();
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.APP_AUTH, DataEventTypeEnum.DELETE, Collections.singletonList(data)));
        }
        return appAuthCount;
    }

    @Override
    public String enabled(List<String> ids, Boolean enabled) {
        ArrayList authDataList = Lists.newArrayList();
        for (String id : ids) {
            AppAuthDO appAuthDO = this.appAuthMapper.selectById(id);
            if (Objects.isNull(appAuthDO)) {
                return "ID NOT EXIST!";
            }
            appAuthDO.setEnabled(enabled);
            this.appAuthMapper.updateEnable(appAuthDO);
            authDataList.add(this.buildByEntity(appAuthDO));
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.APP_AUTH, DataEventTypeEnum.UPDATE, authDataList));
        return "";
    }

    @Override
    public AppAuthVO findById(String id) {
        AppAuthVO appAuthVO = AppAuthTransfer.INSTANCE.mapToVO(this.appAuthMapper.selectById(id));
        List<AuthParamDO> authParamDOList = this.authParamMapper.findByAuthId(id);
        if (CollectionUtils.isNotEmpty(authParamDOList)) {
            appAuthVO.setAuthParamVOList(authParamDOList.stream().map(authParamDO -> {
                AuthParamVO vo = new AuthParamVO();
                vo.setAppName(authParamDO.getAppName());
                vo.setAppParam(authParamDO.getAppParam());
                return vo;
            }).collect(Collectors.toList()));
        }
        appAuthVO.setAuthPathVOList(this.detailPath(id));
        return appAuthVO;
    }

    @Override
    public List<AuthPathVO> detailPath(String id) {
        List<AuthPathDO> authPathDOList = this.authPathMapper.findByAuthId(id);
        if (CollectionUtils.isNotEmpty(authPathDOList)) {
            return authPathDOList.stream().map(authPathDO -> {
                AuthPathVO vo = new AuthPathVO();
                vo.setId(authPathDO.getId());
                vo.setAppName(authPathDO.getAppName());
                vo.setPath(authPathDO.getPath());
                vo.setEnabled(authPathDO.getEnabled());
                return vo;
            }).collect(Collectors.toList());
        }
        return new ArrayList<AuthPathVO>();
    }

    @Override
    public CommonPager<AppAuthVO> listByPage(AppAuthQuery appAuthQuery) {
        return PageResultUtils.result(appAuthQuery.getPageParameter(), () -> this.appAuthMapper.countByQuery(appAuthQuery), () -> this.appAuthMapper.selectByQuery(appAuthQuery).stream().map(AppAuthTransfer.INSTANCE::mapToVO).collect(Collectors.toList()));
    }

    @Override
    public List<AppAuthData> listAll() {
        return this.appAuthMapper.selectAll().stream().map(this::buildByEntity).collect(Collectors.toList());
    }

    @Override
    public ShenyuAdminResult updateAppSecretByAppKey(String appKey, String appSecret) {
        return ShenyuAdminResult.success(this.appAuthMapper.updateAppSecretByAppKey(appKey, appSecret));
    }

    private AppAuthData buildByEntity(AppAuthDO appAuthDO) {
        List<AuthPathDO> authPathDOList;
        AppAuthData data = AppAuthData.builder().appKey(appAuthDO.getAppKey()).appSecret(appAuthDO.getAppSecret()).open(appAuthDO.getOpen()).enabled(appAuthDO.getEnabled()).build();
        List<AuthParamDO> authParamDOList = this.authParamMapper.findByAuthId(appAuthDO.getId());
        if (CollectionUtils.isNotEmpty(authParamDOList)) {
            data.setParamDataList(authParamDOList.stream().map(paramDO -> new AuthParamData(paramDO.getAppName(), paramDO.getAppParam())).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(authPathDOList = this.authPathMapper.findByAuthId(appAuthDO.getId()))) {
            data.setPathDataList(authPathDOList.stream().map(pathDO -> new AuthPathData(pathDO.getAppName(), pathDO.getPath(), pathDO.getEnabled())).collect(Collectors.toList()));
        }
        return data;
    }
}

