/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.model.dto.RuleConditionDTO;
import org.apache.shenyu.admin.model.dto.RuleDTO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.RuleService;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.impl.UpstreamCheckService;
import org.apache.shenyu.admin.service.register.ShenyuClientRegisterService;
import org.apache.shenyu.admin.utils.CommonUpstreamUtils;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.selector.CommonUpstream;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.utils.CollectionUtils;
import org.apache.shenyu.common.utils.PluginNameAdapter;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public abstract class AbstractShenyuClientRegisterServiceImpl
implements ShenyuClientRegisterService {
    @Resource
    private ApplicationEventPublisher eventPublisher;
    @Resource
    private SelectorService selectorService;
    @Resource
    private MetaDataService metaDataService;
    @Resource
    private RuleService ruleService;
    @Resource
    private UpstreamCheckService upstreamCheckService;

    protected abstract String selectorHandler(MetaDataRegisterDTO var1);

    protected abstract String ruleHandler();

    protected abstract void registerMetadata(MetaDataRegisterDTO var1);

    protected abstract String buildHandle(List<URIRegisterDTO> var1, SelectorDO var2);

    @Override
    public String register(MetaDataRegisterDTO dto) {
        String selectorHandler = this.selectorHandler(dto);
        String selectorId = this.selectorService.registerDefault(dto, PluginNameAdapter.rpcTypeAdapter((String)this.rpcType()), selectorHandler);
        String ruleHandler = this.ruleHandler();
        RuleDTO ruleDTO = this.buildRpcDefaultRuleDTO(selectorId, dto, ruleHandler);
        this.ruleService.registerDefault(ruleDTO);
        this.registerMetadata(dto);
        String contextPath = dto.getContextPath();
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            this.registerContextPath(dto);
        }
        return "success";
    }

    @Override
    public String registerURI(String selectorName, List<URIRegisterDTO> uriList) {
        if (CollectionUtils.isEmpty(uriList)) {
            return "";
        }
        SelectorDO selectorDO = this.selectorService.findByNameAndPluginName(selectorName, PluginNameAdapter.rpcTypeAdapter((String)this.rpcType()));
        if (Objects.isNull(selectorDO)) {
            return "";
        }
        String handler = this.buildHandle(uriList, selectorDO);
        selectorDO.setHandle(handler);
        SelectorData selectorData = this.selectorService.buildByName(selectorName, PluginNameAdapter.rpcTypeAdapter((String)this.rpcType()));
        selectorData.setHandle(handler);
        this.selectorService.updateSelective(selectorDO);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.UPDATE, Collections.singletonList(selectorData)));
        return "success";
    }

    public MetaDataService getMetaDataService() {
        return this.metaDataService;
    }

    public SelectorService getSelectorService() {
        return this.selectorService;
    }

    public RuleService getRuleService() {
        return this.ruleService;
    }

    protected void doSubmit(String selectorId, List<? extends CommonUpstream> upstreamList) {
        List<CommonUpstream> commonUpstreamList = CommonUpstreamUtils.convertCommonUpstreamList(upstreamList);
        commonUpstreamList.forEach(upstream -> this.upstreamCheckService.submit(selectorId, (CommonUpstream)upstream));
    }

    protected RuleDTO buildContextPathDefaultRuleDTO(String selectorId, MetaDataRegisterDTO metaDataDTO, String ruleHandler) {
        String contextPath = metaDataDTO.getContextPath();
        return this.buildRuleDTO(selectorId, ruleHandler, contextPath, contextPath + "/**");
    }

    private RuleDTO buildRpcDefaultRuleDTO(String selectorId, MetaDataRegisterDTO metaDataDTO, String ruleHandler) {
        return this.buildRuleDTO(selectorId, ruleHandler, metaDataDTO.getRuleName(), metaDataDTO.getPath());
    }

    private RuleDTO buildRuleDTO(String selectorId, String ruleHandler, String ruleName, String path) {
        RuleDTO ruleDTO = RuleDTO.builder().selectorId(selectorId).name(ruleName).matchMode(MatchModeEnum.AND.getCode()).enabled(Boolean.TRUE).loged(Boolean.TRUE).sort(1).handle(ruleHandler).build();
        RuleConditionDTO ruleConditionDTO = RuleConditionDTO.builder().paramType(ParamTypeEnum.URI.getName()).paramName("/").paramValue(path).build();
        if (path.indexOf("*") > 1) {
            ruleConditionDTO.setOperator(OperatorEnum.MATCH.getAlias());
        } else {
            ruleConditionDTO.setOperator(OperatorEnum.EQ.getAlias());
        }
        ruleDTO.setRuleConditions(Collections.singletonList(ruleConditionDTO));
        return ruleDTO;
    }
}

