/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.shiro.bean;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.shiro.bean.StatelessToken;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class StatelessAuthFilter
extends AccessControlFilter {
    private static final Logger LOG = LoggerFactory.getLogger(StatelessAuthFilter.class);
    private static final String HEAD_TOKEN = "X-Access-Token";

    protected boolean isAccessAllowed(ServletRequest servletRequest, ServletResponse servletResponse, Object o) {
        return false;
    }

    protected boolean onAccessDenied(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        if (StringUtils.equals((CharSequence)HttpMethod.OPTIONS.name(), (CharSequence)httpServletRequest.getMethod())) {
            return true;
        }
        String tokenValue = httpServletRequest.getHeader(HEAD_TOKEN);
        if (StringUtils.isBlank((CharSequence)tokenValue)) {
            LOG.error("token is null.");
            this.unionFailResponse(servletResponse);
            return false;
        }
        StatelessToken token = new StatelessToken(tokenValue);
        Subject subject = this.getSubject(servletRequest, servletResponse);
        try {
            subject.login((AuthenticationToken)token);
        }
        catch (Exception e) {
            LOG.error("token is warning. token : {}.", (Object)tokenValue, (Object)e);
            this.unionFailResponse(servletResponse);
            return false;
        }
        return true;
    }

    private void unionFailResponse(ServletResponse response) throws IOException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setContentType("application/json;charset=utf-8");
        httpResponse.setCharacterEncoding("utf-8");
        this.wrapCorsResponse(httpResponse);
        httpResponse.setStatus(401);
        ShenyuAdminResult result = ShenyuAdminResult.error(600, "token is error");
        httpResponse.getWriter().println(GsonUtils.getInstance().toJson((Object)result));
    }

    private void wrapCorsResponse(HttpServletResponse response) {
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE");
        response.addHeader("Access-Control-Allow-Headers", "Content-Type");
        response.addHeader("Access-Control-Max-Age", "1800");
    }
}

