/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.config.properties.SecretProperties;
import org.apache.shenyu.admin.model.dto.DashboardUserDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.DashboardUserQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.DashboardUserEditVO;
import org.apache.shenyu.admin.model.vo.DashboardUserVO;
import org.apache.shenyu.admin.service.DashboardUserService;
import org.apache.shenyu.admin.utils.AesUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/dashboardUser"})
public class DashboardUserController {
    private final SecretProperties secretProperties;
    private final DashboardUserService dashboardUserService;

    public DashboardUserController(SecretProperties secretProperties, DashboardUserService dashboardUserService) {
        this.secretProperties = secretProperties;
        this.dashboardUserService = dashboardUserService;
    }

    @RequiresPermissions(value={"system:manager:list"})
    @GetMapping(value={""})
    public ShenyuAdminResult queryDashboardUsers(String userName, Integer currentPage, Integer pageSize) {
        CommonPager<DashboardUserVO> commonPager = this.dashboardUserService.listByPage(new DashboardUserQuery(userName, new PageParameter(currentPage, pageSize)));
        if (CollectionUtils.isNotEmpty(commonPager.getDataList())) {
            return ShenyuAdminResult.success("query success", commonPager);
        }
        return ShenyuAdminResult.error("user info is empty");
    }

    @RequiresPermissions(value={"system:manager:list"})
    @GetMapping(value={"/{id}"})
    public ShenyuAdminResult detailDashboardUser(@PathVariable(value="id") String id) {
        DashboardUserEditVO dashboardUserEditVO = this.dashboardUserService.findById(id);
        return Optional.ofNullable(dashboardUserEditVO).map(item -> ShenyuAdminResult.success("detail success", item)).orElseGet(() -> ShenyuAdminResult.error("user info is empty"));
    }

    @RequiresPermissions(value={"system:manager:add"})
    @PostMapping(value={""})
    public ShenyuAdminResult createDashboardUser(@Valid @RequestBody DashboardUserDTO dashboardUserDTO) {
        String key = this.secretProperties.getKey();
        String iv = this.secretProperties.getIv();
        return Optional.ofNullable(dashboardUserDTO).map(item -> {
            item.setPassword(AesUtils.aesEncryption(item.getPassword(), key, iv));
            Integer createCount = this.dashboardUserService.createOrUpdate((DashboardUserDTO)item);
            return ShenyuAdminResult.success("create success", createCount);
        }).orElseGet(() -> ShenyuAdminResult.error("empty user info, please confirm"));
    }

    @RequiresPermissions(value={"system:manager:edit"})
    @PutMapping(value={"/{id}"})
    public ShenyuAdminResult updateDashboardUser(@PathVariable(value="id") String id, @Valid @RequestBody DashboardUserDTO dashboardUserDTO) {
        dashboardUserDTO.setId(id);
        if (StringUtils.isNotBlank((CharSequence)dashboardUserDTO.getPassword())) {
            String key = this.secretProperties.getKey();
            String iv = this.secretProperties.getIv();
            dashboardUserDTO.setPassword(AesUtils.aesEncryption(dashboardUserDTO.getPassword(), key, iv));
        }
        Integer updateCount = this.dashboardUserService.createOrUpdate(dashboardUserDTO);
        return ShenyuAdminResult.success("update success", updateCount);
    }

    @PutMapping(value={"/modify-password/{id}"})
    public ShenyuAdminResult modifyPassword(@PathVariable(value="id") String id, @Valid @RequestBody DashboardUserDTO dashboardUserDTO) {
        return this.updateDashboardUser(id, dashboardUserDTO);
    }

    @RequiresPermissions(value={"system:manager:delete"})
    @DeleteMapping(value={"/batch"})
    public ShenyuAdminResult deleteDashboardUser(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        Integer deleteCount = this.dashboardUserService.delete(ids);
        return ShenyuAdminResult.success("delete success", deleteCount);
    }
}

