/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.apache.shenyu.admin.model.dto.RoleDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.RoleQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.RoleEditVO;
import org.apache.shenyu.admin.model.vo.RoleVO;
import org.apache.shenyu.admin.service.RoleService;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/role"})
public class RoleController {
    private static final String SUPER = "super";
    private final RoleService roleService;

    public RoleController(RoleService roleService) {
        this.roleService = roleService;
    }

    @GetMapping(value={"/getAllRoles"})
    public ShenyuAdminResult selectAll() {
        return ShenyuAdminResult.success("query success", this.roleService.selectAll());
    }

    @GetMapping(value={""})
    public ShenyuAdminResult queryRole(String roleName, Integer currentPage, Integer pageSize) {
        CommonPager<RoleVO> commonPager = this.roleService.listByPage(new RoleQuery(roleName, new PageParameter(currentPage, pageSize)));
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/{id}"})
    public ShenyuAdminResult detailRole(@PathVariable(value="id") String id) {
        RoleEditVO roleEditVO = this.roleService.findById(id);
        return Optional.ofNullable(roleEditVO).map(item -> ShenyuAdminResult.success("detail success", item)).orElse(ShenyuAdminResult.error("detail failed"));
    }

    @PostMapping(value={""})
    public ShenyuAdminResult createRole(@Valid @RequestBody RoleDTO roleDTO) {
        if (SUPER.equals(roleDTO.getRoleName())) {
            return ShenyuAdminResult.error("can not create super role");
        }
        return ShenyuAdminResult.success("create success", this.roleService.createOrUpdate(roleDTO));
    }

    @PutMapping(value={"/{id}"})
    public ShenyuAdminResult updateRole(@PathVariable(value="id") String id, @Valid @RequestBody RoleDTO roleDTO) {
        roleDTO.setId(id);
        return ShenyuAdminResult.success("update success", this.roleService.createOrUpdate(roleDTO));
    }

    @DeleteMapping(value={"/batch"})
    public ShenyuAdminResult deleteRole(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        return ShenyuAdminResult.success("delete success", this.roleService.delete(ids));
    }
}

