/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.websocket;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.listener.websocket.WebsocketConfigurator;
import org.apache.shenyu.admin.service.SyncDataService;
import org.apache.shenyu.admin.spring.SpringBeanUtils;
import org.apache.shenyu.admin.utils.ThreadLocalUtils;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/websocket", configurator=WebsocketConfigurator.class)
public class WebsocketCollector {
    private static final Logger LOG = LoggerFactory.getLogger(WebsocketCollector.class);
    private static final Set<Session> SESSION_SET = new CopyOnWriteArraySet<Session>();
    private static final String SESSION_KEY = "sessionKey";

    @OnOpen
    public void onOpen(Session session) {
        LOG.info("websocket on client[{}] open successful....", (Object)WebsocketCollector.getClientIp(session));
        SESSION_SET.add(session);
    }

    private static String getClientIp(Session session) {
        Map userProperties = session.getUserProperties();
        if (MapUtils.isEmpty((Map)userProperties)) {
            return "";
        }
        return Optional.ofNullable(userProperties.get("ClientIP")).map(Object::toString).orElse("");
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        if (!Objects.equals(message, DataEventTypeEnum.MYSELF.name())) {
            return;
        }
        try {
            ThreadLocalUtils.put(SESSION_KEY, session);
            SpringBeanUtils.getInstance().getBean(SyncDataService.class).syncAll(DataEventTypeEnum.MYSELF);
        }
        finally {
            ThreadLocalUtils.clear();
        }
    }

    @OnClose
    public void onClose(Session session) {
        this.clearSession(session);
        LOG.warn("websocket close on client[{}]", (Object)WebsocketCollector.getClientIp(session));
    }

    @OnError
    public void onError(Session session, Throwable error) {
        this.clearSession(session);
        LOG.error("websocket collection on client[{}] error: ", (Object)WebsocketCollector.getClientIp(session), (Object)error);
    }

    public static void send(String message, DataEventTypeEnum type) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return;
        }
        if (DataEventTypeEnum.MYSELF == type) {
            Session session2 = (Session)ThreadLocalUtils.get(SESSION_KEY);
            if (Objects.nonNull(session2)) {
                WebsocketCollector.sendMessageBySession(session2, message);
            }
        } else {
            SESSION_SET.forEach(session -> WebsocketCollector.sendMessageBySession(session, message));
        }
    }

    private static synchronized void sendMessageBySession(Session session, String message) {
        try {
            session.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            LOG.error("websocket send result is exception: ", (Throwable)e);
        }
    }

    private void clearSession(Session session) {
        SESSION_SET.remove(session);
        ThreadLocalUtils.clear();
    }
}

