/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.zookeeper;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.I0Itec.zkclient.ZkClient;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.common.constant.DefaultPathConstants;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperDataChangedListener
implements DataChangedListener {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperDataChangedListener.class);
    private final ZkClient zkClient;

    public ZookeeperDataChangedListener(ZkClient zkClient) {
        this.zkClient = zkClient;
    }

    @Override
    public void onAppAuthChanged(List<AppAuthData> changed, DataEventTypeEnum eventType) {
        for (AppAuthData data : changed) {
            String appAuthPath = DefaultPathConstants.buildAppAuthPath((String)data.getAppKey());
            if (eventType == DataEventTypeEnum.DELETE) {
                this.deleteZkPath(appAuthPath);
                continue;
            }
            this.insertZkNode(appAuthPath, data);
        }
    }

    @Override
    public void onMetaDataChanged(List<MetaData> changed, DataEventTypeEnum eventType) {
        for (MetaData data : changed) {
            try {
                String metaDataPath = DefaultPathConstants.buildMetaDataPath((String)URLEncoder.encode(data.getPath(), "UTF-8"));
                if (eventType == DataEventTypeEnum.DELETE) {
                    this.deleteZkPath(metaDataPath);
                    continue;
                }
                this.insertZkNode(metaDataPath, data);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("Url encode error.", (Throwable)e);
                throw new ShenyuException(e.getMessage());
            }
        }
    }

    @Override
    public void onPluginChanged(List<PluginData> changed, DataEventTypeEnum eventType) {
        for (PluginData data : changed) {
            String pluginPath = DefaultPathConstants.buildPluginPath((String)data.getName());
            if (eventType == DataEventTypeEnum.DELETE) {
                this.deleteZkPathRecursive(pluginPath);
                String selectorParentPath = DefaultPathConstants.buildSelectorParentPath((String)data.getName());
                this.deleteZkPathRecursive(selectorParentPath);
                String ruleParentPath = DefaultPathConstants.buildRuleParentPath((String)data.getName());
                this.deleteZkPathRecursive(ruleParentPath);
                continue;
            }
            this.insertZkNode(pluginPath, data);
        }
    }

    @Override
    public void onSelectorChanged(List<SelectorData> changed, DataEventTypeEnum eventType) {
        if (eventType == DataEventTypeEnum.REFRESH && CollectionUtils.isNotEmpty(changed)) {
            String selectorParentPath = DefaultPathConstants.buildSelectorParentPath((String)changed.get(0).getPluginName());
            this.deleteZkPathRecursive(selectorParentPath);
        }
        for (SelectorData data : changed) {
            String selectorRealPath = DefaultPathConstants.buildSelectorRealPath((String)data.getPluginName(), (String)data.getId());
            if (eventType == DataEventTypeEnum.DELETE) {
                this.deleteZkPath(selectorRealPath);
                continue;
            }
            String selectorParentPath = DefaultPathConstants.buildSelectorParentPath((String)data.getPluginName());
            this.createZkNode(selectorParentPath);
            this.insertZkNode(selectorRealPath, data);
        }
    }

    @Override
    public void onRuleChanged(List<RuleData> changed, DataEventTypeEnum eventType) {
        if (eventType == DataEventTypeEnum.REFRESH && CollectionUtils.isNotEmpty(changed)) {
            String selectorParentPath = DefaultPathConstants.buildRuleParentPath((String)changed.get(0).getPluginName());
            this.deleteZkPathRecursive(selectorParentPath);
        }
        for (RuleData data : changed) {
            String ruleRealPath = DefaultPathConstants.buildRulePath((String)data.getPluginName(), (String)data.getSelectorId(), (String)data.getId());
            if (eventType == DataEventTypeEnum.DELETE) {
                this.deleteZkPath(ruleRealPath);
                continue;
            }
            String ruleParentPath = DefaultPathConstants.buildRuleParentPath((String)data.getPluginName());
            this.createZkNode(ruleParentPath);
            this.insertZkNode(ruleRealPath, data);
        }
    }

    private void insertZkNode(String path, Object data) {
        this.createZkNode(path);
        this.zkClient.writeData(path, (Object)(null == data ? "" : GsonUtils.getInstance().toJson(data)));
    }

    private void createZkNode(String path) {
        if (!this.zkClient.exists(path)) {
            this.zkClient.createPersistent(path, true);
        }
    }

    private void deleteZkPath(String path) {
        if (this.zkClient.exists(path)) {
            this.zkClient.delete(path);
        }
    }

    private void deleteZkPathRecursive(String path) {
        if (this.zkClient.exists(path)) {
            this.zkClient.deleteRecursive(path);
        }
    }
}

