/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.mapper.DataPermissionMapper;
import org.apache.shenyu.admin.mapper.RuleMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.DataPermissionDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.DataPermissionDO;
import org.apache.shenyu.admin.model.entity.RuleDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.RuleQuery;
import org.apache.shenyu.admin.model.query.SelectorQuery;
import org.apache.shenyu.admin.model.vo.DataPermissionPageVO;
import org.apache.shenyu.admin.service.DataPermissionService;
import org.apache.shenyu.common.enums.AdminDataPermissionTypeEnum;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataPermissionServiceImpl
implements DataPermissionService {
    private final DataPermissionMapper dataPermissionMapper;
    private final RuleMapper ruleMapper;
    private final SelectorMapper selectorMapper;

    public DataPermissionServiceImpl(DataPermissionMapper dataPermissionMapper, RuleMapper ruleMapper, SelectorMapper selectorMapper) {
        this.dataPermissionMapper = dataPermissionMapper;
        this.ruleMapper = ruleMapper;
        this.selectorMapper = selectorMapper;
    }

    @Override
    public List<DataPermissionDO> getUserDataPermissionList(String userId) {
        return this.dataPermissionMapper.listByUserId(userId);
    }

    @Override
    public List<String> getDataPermission(String userId) {
        return this.getUserDataPermissionList(userId).stream().map(DataPermissionDO::getDataId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createSelector(DataPermissionDTO dataPermissionDTO) {
        LinkedList<DataPermissionDO> allDOList = new LinkedList<DataPermissionDO>();
        dataPermissionDTO.setDataType(AdminDataPermissionTypeEnum.SELECTOR.ordinal());
        allDOList.add(DataPermissionDO.buildPermissionDO(dataPermissionDTO));
        List allRuleList = this.ruleMapper.findBySelectorId(dataPermissionDTO.getDataId()).stream().filter(Objects::nonNull).map(ruleDO -> DataPermissionDO.buildCreatePermissionDO(ruleDO.getId(), dataPermissionDTO.getUserId(), AdminDataPermissionTypeEnum.RULE.ordinal())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(allRuleList)) {
            allDOList.addAll(allRuleList);
        }
        return this.dataPermissionMapper.insertBatch(allDOList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int deleteSelector(DataPermissionDTO dataPermissionDTO) {
        List<String> allRuleIds = this.ruleMapper.findBySelectorId(dataPermissionDTO.getDataId()).stream().filter(Objects::nonNull).map(BaseDO::getId).collect(Collectors.toList());
        int count = 0;
        if (CollectionUtils.isNotEmpty(allRuleIds)) {
            count = this.dataPermissionMapper.deleteByDataIdsAndUserId(allRuleIds, dataPermissionDTO.getUserId(), AdminDataPermissionTypeEnum.RULE.ordinal());
        }
        return count += this.dataPermissionMapper.deleteByUniqueKey(dataPermissionDTO.getDataId(), dataPermissionDTO.getUserId(), AdminDataPermissionTypeEnum.SELECTOR.ordinal());
    }

    @Override
    public CommonPager<DataPermissionPageVO> listSelectorsByPage(SelectorQuery selectorQuery, String userId) {
        int totalCount = this.selectorMapper.countByQuery(selectorQuery);
        List selectorList = Collections.emptyList();
        if (totalCount > 0) {
            Supplier<Stream> selectorDOStreamSupplier = () -> this.selectorMapper.selectByQuery(selectorQuery).stream();
            List<String> selectorIds = selectorDOStreamSupplier.get().map(BaseDO::getId).collect(Collectors.toList());
            HashSet<String> hasDataPermissionSelectorIds = new HashSet<String>(this.dataPermissionMapper.selectDataIds(selectorIds, userId, AdminDataPermissionTypeEnum.SELECTOR.ordinal()));
            selectorList = selectorDOStreamSupplier.get().map(selectorDO -> {
                boolean isChecked = hasDataPermissionSelectorIds.contains(selectorDO.getId());
                return DataPermissionPageVO.buildPageVOBySelector(selectorDO, isChecked);
            }).collect(Collectors.toList());
        }
        List finalSelectorList = selectorList;
        return PageResultUtils.result(selectorQuery.getPageParameter(), () -> totalCount, () -> finalSelectorList);
    }

    @Override
    public CommonPager<DataPermissionPageVO> listRulesByPage(RuleQuery ruleQuery, String userId) {
        int totalCount = this.ruleMapper.countByQuery(ruleQuery);
        List selectorList = Collections.emptyList();
        if (totalCount > 0) {
            Supplier<Stream> ruleDOStreamSupplier = () -> this.ruleMapper.selectByQuery(ruleQuery).stream();
            List<String> ruleIds = ruleDOStreamSupplier.get().map(BaseDO::getId).collect(Collectors.toList());
            HashSet<String> hasDataPermissionRuleIds = new HashSet<String>(this.dataPermissionMapper.selectDataIds(ruleIds, userId, AdminDataPermissionTypeEnum.RULE.ordinal()));
            selectorList = ruleDOStreamSupplier.get().map(ruleDO -> {
                boolean isChecked = hasDataPermissionRuleIds.contains(ruleDO.getId());
                return DataPermissionPageVO.buildPageVOByRule(ruleDO, isChecked);
            }).collect(Collectors.toList());
        }
        List finalSelectorList = selectorList;
        return PageResultUtils.result(ruleQuery.getPageParameter(), () -> totalCount, () -> finalSelectorList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createRule(DataPermissionDTO dataPermissionDTO) {
        RuleDO ruleDO = this.ruleMapper.selectById(dataPermissionDTO.getDataId());
        if (Objects.isNull(ruleDO)) {
            return 0;
        }
        int count = 0;
        DataPermissionDO selectorDataPermissionDo = this.dataPermissionMapper.findOneByUniqueKey(ruleDO.getSelectorId(), dataPermissionDTO.getUserId(), AdminDataPermissionTypeEnum.SELECTOR.ordinal());
        if (Objects.isNull(selectorDataPermissionDo)) {
            DataPermissionDO selectorDataPermissionDO = DataPermissionDO.buildCreatePermissionDO(ruleDO.getSelectorId(), dataPermissionDTO.getUserId(), AdminDataPermissionTypeEnum.SELECTOR.ordinal());
            count = this.dataPermissionMapper.insertSelective(selectorDataPermissionDO);
        }
        dataPermissionDTO.setDataType(AdminDataPermissionTypeEnum.RULE.ordinal());
        return count += this.dataPermissionMapper.insertSelective(DataPermissionDO.buildPermissionDO(dataPermissionDTO));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int deleteRule(DataPermissionDTO dataPermissionDTO) {
        return this.dataPermissionMapper.deleteByUniqueKey(dataPermissionDTO.getDataId(), dataPermissionDTO.getUserId(), AdminDataPermissionTypeEnum.RULE.ordinal());
    }
}

