/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.admin.service.register.ShenyuClientRegisterService;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.utils.PluginNameAdapter;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FallbackShenyuClientRegisterService
implements ShenyuClientRegisterService {
    private final Logger logger = LoggerFactory.getLogger(FallbackShenyuClientRegisterService.class);

    @Override
    public String registerURI(String selectorName, List<URIRegisterDTO> uriList) {
        String result = "success";
        try {
            String key = this.key(selectorName);
            ScheduledThread.remove(key);
            result = this.doRegisterURI(selectorName, uriList);
            if (!ScheduledThread.exist(key)) {
                this.logger.info("register success: {},{}", (Object)selectorName, uriList);
            }
        }
        catch (Exception ex) {
            this.logger.warn("register exception", (Throwable)ex);
        }
        return result;
    }

    void recover(String selectorName, List<URIRegisterDTO> uriList) {
        if (uriList != null && !uriList.isEmpty()) {
            String key = this.key(selectorName);
            ScheduledThread.put(key, new FallbackHolder(this, selectorName, uriList));
            this.logger.info("register recovering wait retry: {},{}", (Object)selectorName, uriList);
        }
    }

    private String key(String selectorName) {
        return String.join((CharSequence)":", selectorName, PluginNameAdapter.rpcTypeAdapter((String)this.rpcType()));
    }

    abstract String doRegisterURI(String var1, List<URIRegisterDTO> var2);

    static final class ScheduledThread {
        private static final ScheduledThread INST = new ScheduledThread();
        private final Logger logger = LoggerFactory.getLogger(ScheduledThread.class);
        private final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, ShenyuThreadFactory.create((String)"shenyu-client-register-fallback", (boolean)false));
        private final Map<String, FallbackHolder> fallsRegisters = new ConcurrentHashMap<String, FallbackHolder>();

        private ScheduledThread() {
            this.executorService.scheduleAtFixedRate(() -> {
                try {
                    this.retry();
                }
                catch (Exception ex) {
                    this.logger.warn("retry register failure...");
                }
            }, 0L, 5L, TimeUnit.SECONDS);
        }

        private void retry() {
            HashMap<String, FallbackHolder> failed;
            if (!this.fallsRegisters.isEmpty() && (failed = new HashMap<String, FallbackHolder>(this.fallsRegisters)).size() > 0) {
                this.fallsRegisters.forEach((k, v) -> {
                    this.logger.info("retry register {}", v);
                    v.getRegisterService().registerURI(v.getSelectorName(), v.getUriList());
                });
            }
        }

        public static void put(String key, FallbackHolder fallHolder) {
            INST.doPut(key, fallHolder);
        }

        public void doPut(String key, FallbackHolder fallHolder) {
            this.fallsRegisters.put(key, fallHolder);
        }

        public static void remove(String key) {
            INST.doRemove(key);
        }

        public void doRemove(String key) {
            this.fallsRegisters.remove(key);
        }

        public static boolean exist(String key) {
            return INST.doExist(key);
        }

        public boolean doExist(String key) {
            return this.fallsRegisters.containsKey(key);
        }
    }

    private static final class FallbackHolder {
        private final String selectorName;
        private final List<URIRegisterDTO> uriList;
        private final FallbackShenyuClientRegisterService registerService;

        FallbackHolder(FallbackShenyuClientRegisterService registerService, String selectorName, List<URIRegisterDTO> uriList) {
            this.registerService = registerService;
            this.selectorName = selectorName;
            this.uriList = uriList;
        }

        public String getSelectorName() {
            return this.selectorName;
        }

        public List<URIRegisterDTO> getUriList() {
            return this.uriList;
        }

        public FallbackShenyuClientRegisterService getRegisterService() {
            return this.registerService;
        }
    }
}

