/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.register.AbstractContextPathRegisterService;
import org.apache.shenyu.admin.utils.CommonUpstreamUtils;
import org.apache.shenyu.admin.utils.PathUtils;
import org.apache.shenyu.common.dto.convert.rule.impl.SpringCloudRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.DivideUpstream;
import org.apache.shenyu.common.dto.convert.selector.SpringCloudSelectorHandle;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.springframework.stereotype.Service;

@Service(value="springCloud")
public class ShenyuClientRegisterSpringCloudServiceImpl
extends AbstractContextPathRegisterService {
    @Override
    public String rpcType() {
        return RpcTypeEnum.SPRING_CLOUD.getName();
    }

    @Override
    protected String selectorHandler(MetaDataRegisterDTO metaDataDTO) {
        return GsonUtils.getInstance().toJson((Object)SpringCloudSelectorHandle.builder().serviceId(metaDataDTO.getAppName()).build());
    }

    @Override
    protected String ruleHandler() {
        return new SpringCloudRuleHandle().toJson();
    }

    @Override
    protected void registerMetadata(MetaDataRegisterDTO metaDataDTO) {
        MetaDataService metaDataService = this.getMetaDataService();
        metaDataDTO.setPath(PathUtils.decoratorPath(metaDataDTO.getContextPath()));
        MetaDataDO metaDataDO = metaDataService.findByPath(metaDataDTO.getPath());
        metaDataService.saveOrUpdateMetaData(metaDataDO, metaDataDTO);
    }

    @Override
    protected String buildHandle(List<URIRegisterDTO> uriList, SelectorDO selectorDO) {
        List<DivideUpstream> addList = this.buildDivideUpstreamList(uriList);
        SpringCloudSelectorHandle springCloudSelectorHandle = (SpringCloudSelectorHandle)GsonUtils.getInstance().fromJson(selectorDO.getHandle(), SpringCloudSelectorHandle.class);
        List existList = springCloudSelectorHandle.getDivideUpstreams();
        if (CollectionUtils.isEmpty((Collection)existList)) {
            return this.doHandler(springCloudSelectorHandle, addList, addList, selectorDO);
        }
        CopyOnWriteArrayList<DivideUpstream> canAddList = new CopyOnWriteArrayList<DivideUpstream>();
        List diffList = addList.stream().filter(divideUpstream -> !existList.contains(divideUpstream)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(diffList)) {
            canAddList.addAll(diffList);
            existList.addAll(diffList);
        }
        return this.doHandler(springCloudSelectorHandle, existList, canAddList, selectorDO);
    }

    private String doHandler(SpringCloudSelectorHandle springCloudSelectorHandle, List<DivideUpstream> existList, List<DivideUpstream> canAddList, SelectorDO selectorDO) {
        springCloudSelectorHandle.setDivideUpstreams(existList);
        this.doSubmit(selectorDO.getId(), canAddList);
        return GsonUtils.getInstance().toJson((Object)springCloudSelectorHandle);
    }

    private List<DivideUpstream> buildDivideUpstreamList(List<URIRegisterDTO> uriList) {
        return uriList.stream().map(dto -> CommonUpstreamUtils.buildDefaultDivideUpstream(dto.getHost(), dto.getPort())).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
    }
}

