/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.spring;

import com.google.common.base.Splitter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.shenyu.admin.config.properties.DataBaseProperties;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="'${shenyu.database.dialect}' == 'mysql' or '${shenyu.database.dialect}' == 'h2'")
public class LocalDataSourceLoader
implements InstantiationAwareBeanPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDataSourceLoader.class);
    private static final String PRE_FIX = "file:";
    private static final String DELIMITER = ";;";
    @Resource
    private DataBaseProperties dataBaseProperties;

    public Object postProcessAfterInitialization(@NonNull Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSourceProperties && this.dataBaseProperties.getInitEnable().booleanValue()) {
            this.init((DataSourceProperties)bean);
        }
        return bean;
    }

    protected void init(DataSourceProperties properties) {
        try {
            String jdbcUrl = StringUtils.replace((String)properties.getUrl(), (String)"/shenyu?", (String)"?");
            Connection connection = DriverManager.getConnection(jdbcUrl, properties.getUsername(), properties.getPassword());
            this.execute(connection, this.dataBaseProperties.getInitScript());
        }
        catch (Exception e) {
            LOG.error("Datasource init error.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Connection conn, String script) throws Exception {
        ScriptRunner runner = new ScriptRunner(conn);
        try {
            runner.setLogWriter(null);
            runner.setAutoCommit(true);
            runner.setFullLineDelimiter(false);
            runner.setDelimiter(DELIMITER);
            runner.setSendFullScript(false);
            runner.setStopOnError(false);
            Resources.setCharset((Charset)StandardCharsets.UTF_8);
            List initScripts = Splitter.on((String)";").splitToList((CharSequence)script);
            for (String sqlScript : initScripts) {
                if (sqlScript.startsWith(PRE_FIX)) {
                    String sqlFile = sqlScript.substring(PRE_FIX.length());
                    Reader fileReader = LocalDataSourceLoader.getResourceAsReader(sqlFile);
                    Throwable throwable = null;
                    try {
                        LOG.info("execute shenyu schema sql: {}", (Object)sqlFile);
                        runner.runScript(fileReader);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileReader == null) continue;
                        if (throwable != null) {
                            try {
                                fileReader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fileReader.close();
                        continue;
                    }
                }
                Reader fileReader = Resources.getResourceAsReader((String)sqlScript);
                Throwable throwable = null;
                try {
                    LOG.info("execute shenyu schema sql: {}", (Object)sqlScript);
                    runner.runScript(fileReader);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (fileReader == null) continue;
                    if (throwable != null) {
                        try {
                            fileReader.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    fileReader.close();
                }
            }
        }
        finally {
            runner.closeConnection();
        }
    }

    private static Reader getResourceAsReader(String resource) throws IOException {
        return new InputStreamReader((InputStream)new FileInputStream(resource), StandardCharsets.UTF_8);
    }
}

