/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.spring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.shenyu.admin.config.properties.DataBaseProperties;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"shenyu.database.dialect"}, havingValue="postgresql")
public class PostgreSQLLoader
implements InstantiationAwareBeanPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(PostgreSQLLoader.class);
    @Resource
    private DataBaseProperties dataBaseProperties;

    public Object postProcessAfterInitialization(@NonNull Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSourceProperties && this.dataBaseProperties.getInitEnable().booleanValue()) {
            this.init((DataSourceProperties)bean);
        }
        return bean;
    }

    protected void init(DataSourceProperties properties) {
        try {
            String jdbcUrl = StringUtils.replace((String)properties.getUrl(), (String)"/shenyu", (String)"/");
            Connection conn = DriverManager.getConnection(jdbcUrl, properties.getUsername(), properties.getPassword());
            this.execute(properties, conn);
        }
        catch (Exception e) {
            LOG.error("Datasource init error.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(DataSourceProperties properties, Connection conn) throws IOException, SQLException {
        ScriptRunner runner = new ScriptRunner(conn);
        try {
            runner.setLogWriter(null);
            runner.setErrorLogWriter(null);
            runner.setAutoCommit(false);
            runner.setSendFullScript(true);
            Resources.setCharset((Charset)StandardCharsets.UTF_8);
            Reader read = this.fillInfoToSqlFile(properties.getUsername(), properties.getPassword());
            runner.runScript(read);
            conn.commit();
        }
        finally {
            runner.closeConnection();
            conn.close();
        }
    }

    private Reader fillInfoToSqlFile(String userName, String password) throws IOException {
        String str;
        BufferedReader reader = new BufferedReader(Resources.getResourceAsReader((String)this.dataBaseProperties.getInitScript()));
        StringBuilder builder = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            builder.append(str.replace("_user TEXT := 'userName'", "_user TEXT := '" + userName + "'").replace("_password TEXT := 'password'", "_password TEXT := '" + password + "'")).append(System.lineSeparator());
        }
        reader.close();
        return new StringReader(builder.toString());
    }
}

