/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.utils;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shenyu.common.dto.convert.selector.CommonUpstream;
import org.apache.shenyu.common.dto.convert.selector.DivideUpstream;
import org.apache.shenyu.common.dto.convert.selector.DubboUpstream;
import org.apache.shenyu.common.dto.convert.selector.GrpcUpstream;
import org.apache.shenyu.common.dto.convert.selector.TarsUpstream;

public class CommonUpstreamUtils {
    public static DivideUpstream buildDefaultDivideUpstream(String host, Integer port) {
        return DivideUpstream.builder().upstreamHost("localhost").protocol("http://").upstreamUrl(CommonUpstreamUtils.buildUrl(host, port)).weight(50).warmup(10).timestamp(System.currentTimeMillis()).build();
    }

    public static DivideUpstream buildDivideUpstream(String protocol, String host, Integer port) {
        return DivideUpstream.builder().upstreamHost("localhost").protocol(protocol).upstreamUrl(CommonUpstreamUtils.buildUrl(host, port)).weight(50).warmup(10).timestamp(System.currentTimeMillis()).build();
    }

    public static DubboUpstream buildDefaultDubboUpstream(String host, Integer port) {
        return DubboUpstream.builder().upstreamHost("localhost").protocol("dubbo://").upstreamUrl(CommonUpstreamUtils.buildUrl(host, port)).weight(50).warmup(10).timestamp(System.currentTimeMillis()).build();
    }

    public static GrpcUpstream buildDefaultGrpcUpstream(String host, Integer port) {
        return GrpcUpstream.builder().upstreamUrl(CommonUpstreamUtils.buildUrl(host, port)).weight(50).timestamp(System.currentTimeMillis()).build();
    }

    public static TarsUpstream buildDefaultTarsUpstream(String host, Integer port) {
        return TarsUpstream.builder().upstreamUrl(CommonUpstreamUtils.buildUrl(host, port)).weight(50).warmup(10).timestamp(System.currentTimeMillis()).build();
    }

    public static List<CommonUpstream> convertCommonUpstreamList(List<? extends CommonUpstream> upstreamList) {
        return upstreamList.stream().map(upstream -> new CommonUpstream(upstream.getProtocol(), upstream.getUpstreamHost(), upstream.getUpstreamUrl())).collect(Collectors.toList());
    }

    public static String buildUrl(String host, Integer port) {
        return Optional.of(String.join((CharSequence)":", host, String.valueOf(port))).orElse(null);
    }
}

