/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import com.alibaba.nacos.api.config.ConfigService;
import com.ecwid.consul.v1.ConsulClient;
import io.etcd.jetcd.Client;
import org.I0Itec.zkclient.ZkClient;
import org.apache.shenyu.admin.config.NacosConfiguration;
import org.apache.shenyu.admin.config.ZookeeperConfiguration;
import org.apache.shenyu.admin.config.properties.ConsulProperties;
import org.apache.shenyu.admin.config.properties.EtcdProperties;
import org.apache.shenyu.admin.config.properties.HttpSyncProperties;
import org.apache.shenyu.admin.config.properties.WebsocketSyncProperties;
import org.apache.shenyu.admin.listener.DataChangedInit;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.admin.listener.consul.ConsulDataChangedInit;
import org.apache.shenyu.admin.listener.consul.ConsulDataChangedListener;
import org.apache.shenyu.admin.listener.etcd.EtcdClient;
import org.apache.shenyu.admin.listener.etcd.EtcdDataChangedInit;
import org.apache.shenyu.admin.listener.etcd.EtcdDataDataChangedListener;
import org.apache.shenyu.admin.listener.http.HttpLongPollingDataChangedListener;
import org.apache.shenyu.admin.listener.nacos.NacosDataChangedInit;
import org.apache.shenyu.admin.listener.nacos.NacosDataChangedListener;
import org.apache.shenyu.admin.listener.websocket.WebsocketCollector;
import org.apache.shenyu.admin.listener.websocket.WebsocketDataChangedListener;
import org.apache.shenyu.admin.listener.zookeeper.ZookeeperDataChangedInit;
import org.apache.shenyu.admin.listener.zookeeper.ZookeeperDataChangedListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;

@Configuration
public class DataSyncConfiguration {

    @Configuration
    @ConditionalOnProperty(prefix="shenyu.sync.consul", name={"url"})
    @EnableConfigurationProperties(value={ConsulProperties.class})
    static class ConsulListener {
        ConsulListener() {
        }

        @Bean
        public ConsulClient consulClient(ConsulProperties consulProperties) {
            return new ConsulClient(consulProperties.getUrl());
        }

        @Bean
        @ConditionalOnMissingBean(value={ConsulDataChangedListener.class})
        public DataChangedListener consulDataChangedListener(ConsulClient consulClient) {
            return new ConsulDataChangedListener(consulClient);
        }

        @Bean
        @ConditionalOnMissingBean(value={ConsulDataChangedInit.class})
        public DataChangedInit consulDataChangedInit(ConsulClient consulClient) {
            return new ConsulDataChangedInit(consulClient);
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="shenyu.sync.etcd", name={"url"})
    @EnableConfigurationProperties(value={EtcdProperties.class})
    static class EtcdListener {
        EtcdListener() {
        }

        @Bean
        public EtcdClient etcdClient(EtcdProperties etcdProperties) {
            Client client = Client.builder().endpoints(etcdProperties.getUrl().split(",")).build();
            return new EtcdClient(client);
        }

        @Bean
        @ConditionalOnMissingBean(value={EtcdDataDataChangedListener.class})
        public DataChangedListener etcdDataChangedListener(EtcdClient etcdClient) {
            return new EtcdDataDataChangedListener(etcdClient);
        }

        @Bean
        @ConditionalOnMissingBean(value={EtcdDataChangedInit.class})
        public DataChangedInit etcdDataChangedInit(EtcdClient etcdClient) {
            return new EtcdDataChangedInit(etcdClient);
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"shenyu.sync.websocket.enabled"}, havingValue="true", matchIfMissing=true)
    @EnableConfigurationProperties(value={WebsocketSyncProperties.class})
    static class WebsocketListener {
        WebsocketListener() {
        }

        @Bean
        @ConditionalOnMissingBean(value={WebsocketDataChangedListener.class})
        public DataChangedListener websocketDataChangedListener() {
            return new WebsocketDataChangedListener();
        }

        @Bean
        @ConditionalOnMissingBean(value={WebsocketCollector.class})
        public WebsocketCollector websocketCollector() {
            return new WebsocketCollector();
        }

        @Bean
        @ConditionalOnMissingBean(value={ServerEndpointExporter.class})
        public ServerEndpointExporter serverEndpointExporter() {
            return new ServerEndpointExporter();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="shenyu.sync.nacos", name={"url"})
    @Import(value={NacosConfiguration.class})
    static class NacosListener {
        NacosListener() {
        }

        @Bean
        @ConditionalOnMissingBean(value={NacosDataChangedListener.class})
        public DataChangedListener nacosDataChangedListener(ConfigService configService) {
            return new NacosDataChangedListener(configService);
        }

        @Bean
        @ConditionalOnMissingBean(value={NacosDataChangedInit.class})
        public DataChangedInit nacosDataChangedInit(ConfigService configService) {
            return new NacosDataChangedInit(configService);
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="shenyu.sync.zookeeper", name={"url"})
    @Import(value={ZookeeperConfiguration.class})
    static class ZookeeperListener {
        ZookeeperListener() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ZookeeperDataChangedListener.class})
        public DataChangedListener zookeeperDataChangedListener(ZkClient zkClient) {
            return new ZookeeperDataChangedListener(zkClient);
        }

        @Bean
        @ConditionalOnMissingBean(value={ZookeeperDataChangedInit.class})
        public DataChangedInit zookeeperDataChangedInit(ZkClient zkClient) {
            return new ZookeeperDataChangedInit(zkClient);
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"shenyu.sync.http.enabled"}, havingValue="true")
    @EnableConfigurationProperties(value={HttpSyncProperties.class})
    static class HttpLongPollingListener {
        HttpLongPollingListener() {
        }

        @Bean
        @ConditionalOnMissingBean(value={HttpLongPollingDataChangedListener.class})
        public HttpLongPollingDataChangedListener httpLongPollingDataChangedListener(HttpSyncProperties httpSyncProperties) {
            return new HttpLongPollingDataChangedListener(httpSyncProperties);
        }
    }
}

