/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.BatchCommonDTO;
import org.apache.shenyu.admin.model.dto.MetaDataDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.MetaDataQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.MetaDataVO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/meta-data"})
public class MetaDataController {
    private final MetaDataService metaDataService;

    public MetaDataController(MetaDataService metaDataService) {
        this.metaDataService = metaDataService;
    }

    @GetMapping(value={"/queryList"})
    @RequiresPermissions(value={"system:meta:list"})
    public ShenyuAdminResult queryList(String appName, @NotNull(message="currentPage not null") @NotNull(message="currentPage not null") Integer currentPage, @NotNull(message="pageSize not null") @NotNull(message="pageSize not null") Integer pageSize) {
        CommonPager<MetaDataVO> commonPager = this.metaDataService.listByPage(new MetaDataQuery(appName, new PageParameter(currentPage, pageSize)));
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/findAll"})
    @RequiresPermissions(value={"system:meta:list"})
    public ShenyuAdminResult findAll() {
        return ShenyuAdminResult.success("query success", this.metaDataService.findAll());
    }

    @GetMapping(value={"/findAllGroup"})
    @RequiresPermissions(value={"system:meta:list"})
    public ShenyuAdminResult findAllGroup() {
        return ShenyuAdminResult.success("query success", this.metaDataService.findAllGroup());
    }

    @GetMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:meta:edit"})
    public ShenyuAdminResult detail(@PathVariable(value="id") String id) {
        return ShenyuAdminResult.success("detail success", this.metaDataService.findById(id));
    }

    @PostMapping(value={"/createOrUpdate"})
    @RequiresPermissions(value={"system:meta:add", "system:meta:edit"}, logical=Logical.OR)
    public ShenyuAdminResult createOrUpdate(@Valid @RequestBody MetaDataDTO metaDataDTO) {
        return ShenyuAdminResult.success(this.metaDataService.createOrUpdate(metaDataDTO));
    }

    @PostMapping(value={"/batchDeleted"})
    @RequiresPermissions(value={"system:meta:delete"})
    public ShenyuAdminResult batchDeleted(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        Integer deleteCount = this.metaDataService.delete(ids);
        return ShenyuAdminResult.success("delete success", deleteCount);
    }

    @DeleteMapping(value={"/batchDeleted"})
    @RequiresPermissions(value={"system:meta:delete"})
    public ShenyuAdminResult batchDelete(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        return this.batchDeleted(ids);
    }

    @PostMapping(value={"/batchEnabled"})
    @RequiresPermissions(value={"system:meta:disable"})
    public ShenyuAdminResult batchEnabled(@Valid @RequestBody BatchCommonDTO batchCommonDTO) {
        String result = this.metaDataService.enabled(batchCommonDTO.getIds(), batchCommonDTO.getEnabled());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("enable success");
    }

    @PostMapping(value={"/syncData"})
    @RequiresPermissions(value={"system:meta:modify"})
    public ShenyuAdminResult syncData() {
        this.metaDataService.syncData();
        return ShenyuAdminResult.success();
    }
}

