/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.model.dto.BatchCommonDTO;
import org.apache.shenyu.admin.model.dto.PluginDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.PluginQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.PluginVO;
import org.apache.shenyu.admin.service.PluginService;
import org.apache.shenyu.admin.service.SyncDataService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/plugin"})
public class PluginController {
    private final PluginService pluginService;
    private final SyncDataService syncDataService;

    public PluginController(PluginService pluginService, SyncDataService syncDataService) {
        this.pluginService = pluginService;
        this.syncDataService = syncDataService;
    }

    @GetMapping(value={""})
    @RequiresPermissions(value={"system:plugin:list"})
    public ShenyuAdminResult queryPlugins(String name, Integer enabled, @NotNull Integer currentPage, @NotNull Integer pageSize) {
        CommonPager<PluginVO> commonPager = this.pluginService.listByPage(new PluginQuery(name, enabled, new PageParameter(currentPage, pageSize)));
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/all"})
    @RequiresPermissions(value={"system:plugin:list"})
    public ShenyuAdminResult queryAllPlugins() {
        List<PluginData> pluginDataList = this.pluginService.listAll();
        return ShenyuAdminResult.success("query success", pluginDataList);
    }

    @GetMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:plugin:edit"})
    public ShenyuAdminResult detailPlugin(@PathVariable(value="id") @Existed(message="plugin is not existed", provider=PluginMapper.class) @Existed(message="plugin is not existed", provider=PluginMapper.class) String id) {
        PluginVO pluginVO = this.pluginService.findById(id);
        return ShenyuAdminResult.success("detail success", pluginVO);
    }

    @PostMapping(value={""})
    @RequiresPermissions(value={"system:plugin:add"})
    public ShenyuAdminResult createPlugin(@Valid @RequestBody PluginDTO pluginDTO) {
        return ShenyuAdminResult.success(this.pluginService.createOrUpdate(pluginDTO));
    }

    @PutMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:plugin:edit"})
    public ShenyuAdminResult updatePlugin(@PathVariable(value="id") @Existed(message="plugin is not existed", provider=PluginMapper.class) @Existed(message="plugin is not existed", provider=PluginMapper.class) String id, @Valid @RequestBody PluginDTO pluginDTO) {
        pluginDTO.setId(id);
        return this.createPlugin(pluginDTO);
    }

    @DeleteMapping(value={"/batch"})
    @RequiresPermissions(value={"system:plugin:delete"})
    public ShenyuAdminResult deletePlugins(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        String result = this.pluginService.delete(ids);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("delete success");
    }

    @PostMapping(value={"/enabled"})
    @RequiresPermissions(value={"system:plugin:disable"})
    public ShenyuAdminResult enabled(@Valid @RequestBody BatchCommonDTO batchCommonDTO) {
        String result = this.pluginService.enabled(batchCommonDTO.getIds(), batchCommonDTO.getEnabled());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("enable success");
    }

    @PostMapping(value={"/syncPluginAll"})
    @RequiresPermissions(value={"system:plugin:modify"})
    public ShenyuAdminResult syncPluginAll() {
        boolean success = this.syncDataService.syncAll(DataEventTypeEnum.REFRESH);
        if (success) {
            return ShenyuAdminResult.success("sync success");
        }
        return ShenyuAdminResult.error("sync fail");
    }

    @PutMapping(value={"/syncPluginData/{id}"})
    @RequiresPermissions(value={"system:plugin:modify"})
    public ShenyuAdminResult syncPluginData(@PathVariable(value="id") @Existed(message="plugin is not existed", provider=PluginMapper.class) @Existed(message="plugin is not existed", provider=PluginMapper.class) String id) {
        boolean success = this.syncDataService.syncPluginData(id);
        if (success) {
            return ShenyuAdminResult.success("sync success");
        }
        return ShenyuAdminResult.error("sync fail");
    }
}

