/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.mapper.ResourceMapper;
import org.apache.shenyu.admin.model.dto.ResourceDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.ResourceQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.PermissionMenuVO;
import org.apache.shenyu.admin.model.vo.ResourceVO;
import org.apache.shenyu.admin.service.ResourceService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/resource"})
public class ResourceController {
    private final ResourceService resourceService;

    public ResourceController(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    @GetMapping(value={""})
    @RequiresPermissions(value={"system:resource:list"})
    public ShenyuAdminResult queryResource(String title, @NotNull Integer currentPage, @NotNull Integer pageSize) {
        CommonPager<ResourceVO> commonPager = this.resourceService.listByPage(new ResourceQuery(title, new PageParameter(currentPage, pageSize)));
        if (CollectionUtils.isNotEmpty(commonPager.getDataList())) {
            return ShenyuAdminResult.success("query success", commonPager);
        }
        return ShenyuAdminResult.error("query failed");
    }

    @GetMapping(value={"/menu"})
    @RequiresPermissions(value={"system:manager:configureDataPermission"})
    public ShenyuAdminResult getMenuTree() {
        List<PermissionMenuVO.MenuInfo> menuInfoList = this.resourceService.getMenuTree();
        if (CollectionUtils.isNotEmpty(menuInfoList)) {
            return ShenyuAdminResult.success("query success", menuInfoList);
        }
        return ShenyuAdminResult.error("query failed");
    }

    @GetMapping(value={"/button"})
    @RequiresPermissions(value={"system:resource:addButton"})
    public ShenyuAdminResult getButton(String id) {
        List<ResourceVO> resourceVOList = this.resourceService.findByParentId(id);
        if (CollectionUtils.isNotEmpty(resourceVOList)) {
            return ShenyuAdminResult.success("query success", resourceVOList);
        }
        return ShenyuAdminResult.error("query failed");
    }

    @GetMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:resource:editButton", "system:resource:editMenu"}, logical=Logical.OR)
    public ShenyuAdminResult detailResource(@PathVariable(value="id") String id) {
        return Optional.ofNullable(this.resourceService.findById(id)).map(item -> ShenyuAdminResult.success("detail success", item)).orElse(ShenyuAdminResult.error("detail failed"));
    }

    @PostMapping(value={""})
    @RequiresPermissions(value={"system:resource:addMenu", "system:resource:addButton"}, logical=Logical.OR)
    public ShenyuAdminResult createResource(@Valid @RequestBody ResourceDTO resourceDTO) {
        return ShenyuAdminResult.success("create success", this.resourceService.createOrUpdate(resourceDTO));
    }

    @PutMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:resource:editMenu", "system:resource:editButton"}, logical=Logical.OR)
    public ShenyuAdminResult updateResource(@PathVariable(value="id") @Valid @Existed(provider=ResourceMapper.class, message="resource not existed") @Valid @Existed(provider=ResourceMapper.class, message="resource not existed") String id, @RequestBody ResourceDTO resourceDTO) {
        resourceDTO.setId(id);
        return ShenyuAdminResult.success("update success", this.resourceService.createOrUpdate(resourceDTO));
    }

    @DeleteMapping(value={"/batch"})
    @RequiresPermissions(value={"system:resource:deleteMenu", "system:resource:deleteButton"}, logical=Logical.OR)
    public ShenyuAdminResult deleteResource(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        return ShenyuAdminResult.success("delete success", this.resourceService.delete(ids));
    }
}

