/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.SelectorDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.SelectorQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.SelectorVO;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/selector"})
public class SelectorController {
    private final SelectorService selectorService;

    public SelectorController(SelectorService selectorService) {
        this.selectorService = selectorService;
    }

    @GetMapping(value={""})
    public ShenyuAdminResult querySelectors(String pluginId, String name, @NotNull Integer currentPage, @NotNull Integer pageSize) {
        CommonPager<SelectorVO> commonPager = this.selectorService.listByPage(new SelectorQuery(pluginId, name, new PageParameter(currentPage, pageSize)));
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/{id}"})
    public ShenyuAdminResult detailSelector(@PathVariable(value="id") @Valid @Existed(provider=SelectorMapper.class, message="selector is not existed") @Valid @Existed(provider=SelectorMapper.class, message="selector is not existed") String id) {
        SelectorVO selectorVO = this.selectorService.findById(id);
        return ShenyuAdminResult.success("detail success", selectorVO);
    }

    @PostMapping(value={""})
    public ShenyuAdminResult createSelector(@Valid @RequestBody SelectorDTO selectorDTO) {
        Integer createCount = this.selectorService.createOrUpdate(selectorDTO);
        return ShenyuAdminResult.success("create success", createCount);
    }

    @PutMapping(value={"/{id}"})
    public ShenyuAdminResult updateSelector(@PathVariable(value="id") @Valid @Existed(provider=SelectorMapper.class, message="selector is not existed") @Valid @Existed(provider=SelectorMapper.class, message="selector is not existed") String id, @Valid @RequestBody SelectorDTO selectorDTO) {
        selectorDTO.setId(id);
        Integer updateCount = this.selectorService.createOrUpdate(selectorDTO);
        return ShenyuAdminResult.success("update success", updateCount);
    }

    @DeleteMapping(value={"/batch"})
    public ShenyuAdminResult deleteSelector(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        Integer deleteCount = this.selectorService.delete(ids);
        return ShenyuAdminResult.success("delete success", deleteCount);
    }
}

