/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.disruptor;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.disruptor.executor.RegisterServerConsumerExecutor;
import org.apache.shenyu.admin.disruptor.subscriber.MetadataExecutorSubscriber;
import org.apache.shenyu.admin.disruptor.subscriber.URIRegisterExecutorSubscriber;
import org.apache.shenyu.admin.service.register.ShenyuClientRegisterService;
import org.apache.shenyu.disruptor.DisruptorProviderManage;
import org.apache.shenyu.disruptor.consumer.QueueConsumerFactory;
import org.apache.shenyu.disruptor.provider.DisruptorProvider;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.apache.shenyu.register.server.api.ShenyuServerRegisterPublisher;

public class RegisterServerDisruptorPublisher
implements ShenyuServerRegisterPublisher {
    private static final RegisterServerDisruptorPublisher INSTANCE = new RegisterServerDisruptorPublisher();
    private DisruptorProviderManage<Collection<DataTypeParent>> providerManage;

    public static RegisterServerDisruptorPublisher getInstance() {
        return INSTANCE;
    }

    public void start(Map<String, ShenyuClientRegisterService> shenyuClientRegisterService) {
        RegisterServerConsumerExecutor.RegisterServerExecutorFactory factory = new RegisterServerConsumerExecutor.RegisterServerExecutorFactory();
        factory.addSubscribers(new URIRegisterExecutorSubscriber(shenyuClientRegisterService));
        factory.addSubscribers(new MetadataExecutorSubscriber(shenyuClientRegisterService));
        this.providerManage = new DisruptorProviderManage((QueueConsumerFactory)factory);
        this.providerManage.startup();
    }

    public void publish(DataTypeParent data) {
        DisruptorProvider provider = this.providerManage.getProvider();
        provider.onData(Collections.singleton(data));
    }

    public void publish(Collection<? extends DataTypeParent> dataList) {
        DisruptorProvider provider = this.providerManage.getProvider();
        provider.onData(dataList.stream().map(DataTypeParent.class::cast).collect(Collectors.toList()));
    }

    public void close() {
        this.providerManage.getProvider().shutdown();
    }
}

