/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.nacos;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class NacosDataChangedListener
implements DataChangedListener {
    private static final Logger LOG = LoggerFactory.getLogger(NacosDataChangedListener.class);
    private static final ConcurrentMap<String, PluginData> PLUGIN_MAP = Maps.newConcurrentMap();
    private static final ConcurrentMap<String, List<SelectorData>> SELECTOR_MAP = Maps.newConcurrentMap();
    private static final ConcurrentMap<String, List<RuleData>> RULE_MAP = Maps.newConcurrentMap();
    private static final ConcurrentMap<String, AppAuthData> AUTH_MAP = Maps.newConcurrentMap();
    private static final ConcurrentMap<String, MetaData> META_DATA = Maps.newConcurrentMap();
    private static final Comparator<SelectorData> SELECTOR_DATA_COMPARATOR = Comparator.comparing(SelectorData::getSort);
    private static final Comparator<RuleData> RULE_DATA_COMPARATOR = Comparator.comparing(RuleData::getSort);
    private final ConfigService configService;

    public NacosDataChangedListener(ConfigService configService) {
        this.configService = configService;
    }

    @Override
    public void onAppAuthChanged(List<AppAuthData> changed, DataEventTypeEnum eventType) {
        this.updateAuthMap(this.getConfig("shenyu.auth.json"));
        switch (eventType) {
            case DELETE: {
                changed.forEach(appAuth -> {
                    AppAuthData cfr_ignored_0 = (AppAuthData)AUTH_MAP.remove(appAuth.getAppKey());
                });
                break;
            }
            case REFRESH: 
            case MYSELF: {
                HashSet set = new HashSet(AUTH_MAP.keySet());
                changed.forEach(appAuth -> {
                    set.remove(appAuth.getAppKey());
                    AUTH_MAP.put(appAuth.getAppKey(), (AppAuthData)appAuth);
                });
                AUTH_MAP.keySet().removeAll(set);
                break;
            }
            default: {
                changed.forEach(appAuth -> AUTH_MAP.put(appAuth.getAppKey(), (AppAuthData)appAuth));
            }
        }
        this.publishConfig("shenyu.auth.json", AUTH_MAP);
    }

    @Override
    public void onPluginChanged(List<PluginData> changed, DataEventTypeEnum eventType) {
        this.updatePluginMap(this.getConfig("shenyu.plugin.json"));
        switch (eventType) {
            case DELETE: {
                changed.forEach(plugin -> {
                    PluginData cfr_ignored_0 = (PluginData)PLUGIN_MAP.remove(plugin.getName());
                });
                break;
            }
            case REFRESH: 
            case MYSELF: {
                HashSet set = new HashSet(PLUGIN_MAP.keySet());
                changed.forEach(plugin -> {
                    set.remove(plugin.getName());
                    PLUGIN_MAP.put(plugin.getName(), (PluginData)plugin);
                });
                PLUGIN_MAP.keySet().removeAll(set);
                break;
            }
            default: {
                changed.forEach(plugin -> PLUGIN_MAP.put(plugin.getName(), (PluginData)plugin));
            }
        }
        this.publishConfig("shenyu.plugin.json", PLUGIN_MAP);
    }

    @Override
    public void onSelectorChanged(List<SelectorData> changed, DataEventTypeEnum eventType) {
        this.updateSelectorMap(this.getConfig("shenyu.selector.json"));
        switch (eventType) {
            case DELETE: {
                changed.forEach(selector -> {
                    List ls = ((List)SELECTOR_MAP.getOrDefault(selector.getPluginName(), new ArrayList())).stream().filter(s -> !s.getId().equals(selector.getId())).sorted(SELECTOR_DATA_COMPARATOR).collect(Collectors.toList());
                    SELECTOR_MAP.put(selector.getPluginName(), ls);
                });
                break;
            }
            case REFRESH: 
            case MYSELF: {
                if (CollectionUtils.isNotEmpty(changed)) {
                    SELECTOR_MAP.remove(changed.get(0).getPluginName());
                }
                changed.forEach(selector -> {
                    ArrayList<SelectorData> ls = new ArrayList<SelectorData>(SELECTOR_MAP.getOrDefault(selector.getPluginName(), new ArrayList()));
                    ls.add((SelectorData)selector);
                    ls.sort(SELECTOR_DATA_COMPARATOR);
                    SELECTOR_MAP.put(selector.getPluginName(), ls);
                });
                break;
            }
            default: {
                changed.forEach(selector -> {
                    List ls = ((List)SELECTOR_MAP.getOrDefault(selector.getPluginName(), new ArrayList())).stream().filter(s -> !s.getId().equals(selector.getId())).collect(Collectors.toList());
                    ls.add(selector);
                    ls.sort(SELECTOR_DATA_COMPARATOR);
                    SELECTOR_MAP.put(selector.getPluginName(), ls);
                });
            }
        }
        this.publishConfig("shenyu.selector.json", SELECTOR_MAP);
    }

    @Override
    public void onMetaDataChanged(List<MetaData> changed, DataEventTypeEnum eventType) {
        this.updateMetaDataMap(this.getConfig("shenyu.meta.json"));
        switch (eventType) {
            case DELETE: {
                changed.forEach(meta -> {
                    MetaData cfr_ignored_0 = (MetaData)META_DATA.remove(meta.getPath());
                });
                break;
            }
            case REFRESH: 
            case MYSELF: {
                HashSet set = new HashSet(META_DATA.keySet());
                changed.forEach(meta -> {
                    set.remove(meta.getPath());
                    META_DATA.put(meta.getPath(), (MetaData)meta);
                });
                META_DATA.keySet().removeAll(set);
                break;
            }
            default: {
                changed.forEach(meta -> {
                    META_DATA.values().stream().filter(md -> Objects.equals(md.getId(), meta.getId())).forEach(md -> {
                        MetaData cfr_ignored_0 = (MetaData)META_DATA.remove(md.getPath());
                    });
                    META_DATA.put(meta.getPath(), (MetaData)meta);
                });
            }
        }
        this.publishConfig("shenyu.meta.json", META_DATA);
    }

    @Override
    public void onRuleChanged(List<RuleData> changed, DataEventTypeEnum eventType) {
        this.updateRuleMap(this.getConfig("shenyu.rule.json"));
        switch (eventType) {
            case DELETE: {
                changed.forEach(rule -> {
                    List ls = ((List)RULE_MAP.getOrDefault(rule.getSelectorId(), new ArrayList())).stream().filter(s -> !s.getId().equals(rule.getId())).sorted(RULE_DATA_COMPARATOR).collect(Collectors.toList());
                    RULE_MAP.put(rule.getSelectorId(), ls);
                });
                break;
            }
            case REFRESH: 
            case MYSELF: {
                Set selectIdSet = changed.stream().map(RuleData::getSelectorId).collect(Collectors.toSet());
                RULE_MAP.keySet().removeAll(selectIdSet);
                changed.forEach(rule -> {
                    ArrayList<RuleData> ls = new ArrayList<RuleData>(RULE_MAP.getOrDefault(rule.getSelectorId(), new ArrayList()));
                    ls.add((RuleData)rule);
                    ls.sort(RULE_DATA_COMPARATOR);
                    RULE_MAP.put(rule.getSelectorId(), ls);
                });
                break;
            }
            default: {
                changed.forEach(rule -> {
                    List ls = ((List)RULE_MAP.getOrDefault(rule.getSelectorId(), new ArrayList())).stream().filter(s -> !s.getId().equals(rule.getId())).collect(Collectors.toList());
                    ls.add(rule);
                    ls.sort(RULE_DATA_COMPARATOR);
                    RULE_MAP.put(rule.getSelectorId(), ls);
                });
            }
        }
        this.publishConfig("shenyu.rule.json", RULE_MAP);
    }

    private void publishConfig(String dataId, Object data) {
        try {
            this.configService.publishConfig(dataId, "DEFAULT_GROUP", GsonUtils.getInstance().toJson(data));
        }
        catch (NacosException e) {
            LOG.error("Publish data to nacos error.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }

    private String getConfig(String dataId) {
        try {
            String config = this.configService.getConfig(dataId, "DEFAULT_GROUP", 6000L);
            return StringUtils.hasLength((String)config) ? config : "{}";
        }
        catch (NacosException e) {
            LOG.error("Get data from nacos error.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }

    private void updateAuthMap(String configInfo) {
        JsonObject jo = (JsonObject)GsonUtils.getInstance().fromJson(configInfo, JsonObject.class);
        HashSet set = new HashSet(AUTH_MAP.keySet());
        for (Map.Entry e : jo.entrySet()) {
            set.remove(e.getKey());
            AUTH_MAP.put((String)e.getKey(), (AppAuthData)GsonUtils.getInstance().fromJson((JsonElement)e.getValue(), AppAuthData.class));
        }
        AUTH_MAP.keySet().removeAll(set);
    }

    private void updatePluginMap(String configInfo) {
        JsonObject jo = (JsonObject)GsonUtils.getInstance().fromJson(configInfo, JsonObject.class);
        HashSet set = new HashSet(PLUGIN_MAP.keySet());
        for (Map.Entry e : jo.entrySet()) {
            set.remove(e.getKey());
            PLUGIN_MAP.put((String)e.getKey(), (PluginData)GsonUtils.getInstance().fromJson((JsonElement)e.getValue(), PluginData.class));
        }
        PLUGIN_MAP.keySet().removeAll(set);
    }

    private void updateSelectorMap(String configInfo) {
        JsonObject jo = (JsonObject)GsonUtils.getInstance().fromJson(configInfo, JsonObject.class);
        HashSet set = new HashSet(SELECTOR_MAP.keySet());
        for (Map.Entry e : jo.entrySet()) {
            set.remove(e.getKey());
            ArrayList ls = new ArrayList();
            ((JsonElement)e.getValue()).getAsJsonArray().forEach(je -> ls.add(GsonUtils.getInstance().fromJson(je, SelectorData.class)));
            SELECTOR_MAP.put((String)e.getKey(), ls);
        }
        SELECTOR_MAP.keySet().removeAll(set);
    }

    private void updateMetaDataMap(String configInfo) {
        JsonObject jo = (JsonObject)GsonUtils.getInstance().fromJson(configInfo, JsonObject.class);
        HashSet set = new HashSet(META_DATA.keySet());
        for (Map.Entry e : jo.entrySet()) {
            set.remove(e.getKey());
            META_DATA.put((String)e.getKey(), (MetaData)GsonUtils.getInstance().fromJson((JsonElement)e.getValue(), MetaData.class));
        }
        META_DATA.keySet().removeAll(set);
    }

    private void updateRuleMap(String configInfo) {
        JsonObject jo = (JsonObject)GsonUtils.getInstance().fromJson(configInfo, JsonObject.class);
        HashSet set = new HashSet(RULE_MAP.keySet());
        for (Map.Entry e : jo.entrySet()) {
            set.remove(e.getKey());
            ArrayList ls = new ArrayList();
            ((JsonElement)e.getValue()).getAsJsonArray().forEach(je -> ls.add(GsonUtils.getInstance().fromJson(je, RuleData.class)));
            RULE_MAP.put((String)e.getKey(), ls);
        }
        RULE_MAP.keySet().removeAll(set);
    }
}

