/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.RuleDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class RuleDO
extends BaseDO {
    private static final long serialVersionUID = 8050178277098166539L;
    private String selectorId;
    private Integer matchMode;
    private String name;
    private Boolean enabled;
    private Boolean loged;
    private Integer sort;
    private String handle;

    public RuleDO() {
    }

    public RuleDO(String selectorId, Integer matchMode, String name, Boolean enabled, Boolean loged, Integer sort, String handle) {
        this.selectorId = selectorId;
        this.matchMode = matchMode;
        this.name = name;
        this.enabled = enabled;
        this.loged = loged;
        this.sort = sort;
        this.handle = handle;
    }

    public String getSelectorId() {
        return this.selectorId;
    }

    public void setSelectorId(String selectorId) {
        this.selectorId = selectorId;
    }

    public Integer getMatchMode() {
        return this.matchMode;
    }

    public void setMatchMode(Integer matchMode) {
        this.matchMode = matchMode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getLoged() {
        return this.loged;
    }

    public void setLoged(Boolean loged) {
        this.loged = loged;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public static RuleDOBuilder builder() {
        return new RuleDOBuilder();
    }

    public static RuleDO buildRuleDO(RuleDTO ruleDTO) {
        return Optional.ofNullable(ruleDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            RuleDO ruleDO = RuleDO.builder().selectorId(item.getSelectorId()).matchMode(item.getMatchMode()).name(item.getName()).enabled(item.getEnabled()).loged(item.getLoged()).sort(item.getSort()).handle(item.getHandle()).dateUpdated(currentTime).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                ruleDO.setId(UUIDUtils.getInstance().generateShortUuid());
                ruleDO.setDateCreated(currentTime);
            } else {
                ruleDO.setId(item.getId());
            }
            return ruleDO;
        }).orElse(null);
    }

    public static RuleData transFrom(RuleDO ruleDO, String pluginName, List<ConditionData> conditionDataList) {
        return RuleData.builder().id(ruleDO.getId()).name(ruleDO.getName()).pluginName(pluginName).selectorId(ruleDO.getSelectorId()).matchMode(ruleDO.getMatchMode()).sort(ruleDO.getSort()).enabled(ruleDO.getEnabled()).loged(ruleDO.getLoged()).handle(ruleDO.getHandle()).conditionDataList(conditionDataList).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuleDO ruleDO = (RuleDO)o;
        return Objects.equals(this.selectorId, ruleDO.selectorId) && Objects.equals(this.matchMode, ruleDO.matchMode) && Objects.equals(this.name, ruleDO.name) && Objects.equals(this.enabled, ruleDO.enabled) && Objects.equals(this.loged, ruleDO.loged) && Objects.equals(this.sort, ruleDO.sort) && Objects.equals(this.handle, ruleDO.handle);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.selectorId, this.matchMode, this.name, this.enabled, this.loged, this.sort, this.handle);
    }

    public static final class RuleDOBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String selectorId;
        private Integer matchMode;
        private String name;
        private Boolean enabled;
        private Boolean loged;
        private Integer sort;
        private String handle;

        private RuleDOBuilder() {
        }

        public RuleDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public RuleDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public RuleDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public RuleDOBuilder selectorId(String selectorId) {
            this.selectorId = selectorId;
            return this;
        }

        public RuleDOBuilder matchMode(Integer matchMode) {
            this.matchMode = matchMode;
            return this;
        }

        public RuleDOBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RuleDOBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public RuleDOBuilder loged(Boolean loged) {
            this.loged = loged;
            return this;
        }

        public RuleDOBuilder sort(Integer sort) {
            this.sort = sort;
            return this;
        }

        public RuleDOBuilder handle(String handle) {
            this.handle = handle;
            return this;
        }

        public RuleDO build() {
            RuleDO ruleDO = new RuleDO();
            ruleDO.setId(this.id);
            ruleDO.setDateCreated(this.dateCreated);
            ruleDO.setDateUpdated(this.dateUpdated);
            ruleDO.setSelectorId(this.selectorId);
            ruleDO.setMatchMode(this.matchMode);
            ruleDO.setName(this.name);
            ruleDO.setEnabled(this.enabled);
            ruleDO.setLoged(this.loged);
            ruleDO.setSort(this.sort);
            ruleDO.setHandle(this.handle);
            return ruleDO;
        }
    }
}

