/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.mapper.ShenyuDictMapper;
import org.apache.shenyu.admin.model.dto.ShenyuDictDTO;
import org.apache.shenyu.admin.model.entity.ShenyuDictDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.ShenyuDictQuery;
import org.apache.shenyu.admin.model.vo.ShenyuDictVO;
import org.apache.shenyu.admin.service.ShenyuDictService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShenyuDictServiceImpl
implements ShenyuDictService {
    private final ShenyuDictMapper shenyuDictMapper;

    public ShenyuDictServiceImpl(ShenyuDictMapper shenyuDictMapper) {
        this.shenyuDictMapper = shenyuDictMapper;
    }

    @Override
    @Pageable
    public CommonPager<ShenyuDictVO> listByPage(ShenyuDictQuery shenyuDictQuery) {
        return PageResultUtils.result(shenyuDictQuery.getPageParameter(), () -> this.shenyuDictMapper.selectByQuery(shenyuDictQuery).stream().map(ShenyuDictVO::buildShenyuDictVO).collect(Collectors.toList()));
    }

    @Override
    public Integer createOrUpdate(ShenyuDictDTO shenyuDictDTO) {
        return StringUtils.isBlank((CharSequence)shenyuDictDTO.getId()) ? this.shenyuDictMapper.insertSelective(ShenyuDictDO.buildShenyuDictDO(shenyuDictDTO)) : this.shenyuDictMapper.updateByPrimaryKeySelective(ShenyuDictDO.buildShenyuDictDO(shenyuDictDTO));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer deleteShenyuDicts(List<String> ids) {
        return this.shenyuDictMapper.deleteByIdList(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer enabled(List<String> ids, Boolean enabled) {
        return this.shenyuDictMapper.enabled(ids, enabled);
    }

    @Override
    public ShenyuDictVO findById(String id) {
        return ShenyuDictVO.buildShenyuDictVO(this.shenyuDictMapper.selectById(id));
    }

    @Override
    public ShenyuDictVO findByDictCodeName(String dictCode, String dictName) {
        return ShenyuDictVO.buildShenyuDictVO(this.shenyuDictMapper.selectByDictCodeAndDictName(dictCode, dictName));
    }

    @Override
    public List<ShenyuDictVO> list(String type) {
        ShenyuDictQuery shenyuDictQuery = new ShenyuDictQuery();
        shenyuDictQuery.setType(type);
        return this.shenyuDictMapper.selectByQuery(shenyuDictQuery).stream().map(ShenyuDictVO::buildShenyuDictVO).collect(Collectors.toList());
    }
}

